/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence;

import com.systinet.persistence.DatabaseSchemaHelper;
import com.systinet.persistence.FieldSetterManager;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceSqlException;
import java.lang.reflect.Field;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.TreeMap;

class SqlToJavaMapper {
    private SqlToJavaMapper() {
    }

    public static UnpackData prepareUnpack(ResultSet result, Class clazz, ClassLoader loader) throws PersistenceException {
        try {
            if (result == null || clazz == null) {
                throw new NullPointerException("Some param is null");
            }
            ResultSetMetaData metaData = result.getMetaData();
            SqlToJavaMapper.check(metaData, clazz);
            UnpackData unpackData = new UnpackData();
            unpackData.theClass = clazz;
            int colCount = unpackData.columnCount = metaData.getColumnCount();
            UnpackData.access$202(unpackData, new int[colCount]);
            UnpackData.access$302(unpackData, new Field[colCount]);
            UnpackData.access$402(unpackData, new FieldSetterManager.FieldSetter[colCount]);
            Map classFields = SqlToJavaMapper.getFieldMap(clazz);
            DatabaseSchemaHelper dbSchmHlp = DatabaseSchemaHelper.getInstance();
            int i = 1;
            while (i <= colCount) {
                Field theField = (Field)classFields.get(metaData.getColumnName(i));
                int theSqlType = metaData.getColumnType(i);
                FieldSetterManager.FieldSetter theSetter = dbSchmHlp.findSetter(theField.getType(), new Integer(theSqlType));
                if (theSetter == null) {
                    theSetter = loader == null ? dbSchmHlp.getDefaultSetter() : dbSchmHlp.getDefaultSetter(loader);
                }
                int index = i - 1;
                ((UnpackData)unpackData).sqlColumnTypes[index] = theSqlType;
                ((UnpackData)unpackData).fields[index] = theField;
                ((UnpackData)unpackData).columnSetters[index] = theSetter;
                ++i;
            }
            return unpackData;
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static Object unpack(ResultSet result, UnpackData unpackData) throws PersistenceException {
        try {
            void e;
            Object newInstance = unpackData.theClass.newInstance();
            int i = 0;
            while (i < unpackData.columnCount) {
                FieldSetterManager.FieldSetter theSetter = unpackData.columnSetters[i];
                Field theField = unpackData.fields[i];
                int theSqlType = unpackData.sqlColumnTypes[i];
                try {
                    theSetter.setField(theField, newInstance, result, i + 1, theSqlType);
                }
                catch (IllegalAccessException iae) {
                    throw new PersistenceException("IllegalAccess to " + theField, iae);
                }
                catch (IllegalArgumentException iae) {
                    throw new PersistenceException("IllegalArgument when setting " + theField, iae);
                }
                ++i;
            }
            return e;
        }
        catch (InstantiationException e) {
            throw new PersistenceException("Cannot create an instance of " + unpackData.theClass, e);
        }
        catch (IllegalAccessException e) {
            throw new PersistenceException("Illegal access: " + e.getMessage(), e);
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
    }

    private static Map getFieldMap(Class clazz) {
        TreeMap<String, Field> fields = new TreeMap<String, Field>(String.CASE_INSENSITIVE_ORDER);
        Field[] fieldsArray = clazz.getFields();
        int i = 0;
        while (i < fieldsArray.length) {
            Field cf = fieldsArray[i];
            fields.put(cf.getName(), cf);
            ++i;
        }
        return fields;
    }

    private static void check(ResultSetMetaData resMetaData, Class clazz) throws SQLException, PersistenceException {
        Map fields = SqlToJavaMapper.getFieldMap(clazz);
        int colCount = resMetaData.getColumnCount();
        int i = 1;
        while (i <= colCount) {
            String name = resMetaData.getColumnName(i);
            Field field = (Field)fields.get(name);
            if (field == null) {
                throw new PersistenceException("Field '" + name + "' not in class");
            }
            ++i;
        }
    }

    public static class UnpackData {
        private Class theClass;
        private int columnCount;
        private int[] sqlColumnTypes;
        private Field[] fields;
        private FieldSetterManager.FieldSetter[] columnSetters;

        public String toString() {
            return "UnpackData theClass=" + this.theClass + ", columnCount=" + this.columnCount + ", fields=" + Arrays.asList(this.fields) + ", columnSetter=" + Arrays.asList(this.columnSetters);
        }

        static /* synthetic */ int[] access$202(UnpackData x0, int[] x1) {
            x0.sqlColumnTypes = x1;
            return x1;
        }

        static /* synthetic */ Field[] access$302(UnpackData x0, Field[] x1) {
            x0.fields = x1;
            return x1;
        }

        static /* synthetic */ FieldSetterManager.FieldSetter[] access$402(UnpackData x0, FieldSetterManager.FieldSetter[] x1) {
            x0.columnSetters = x1;
            return x1;
        }
    }
}

