/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.oracle;

import com.systinet.persistence.DatabaseSchemaHelper;
import com.systinet.persistence.FieldSetterManager;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.tablemodel.Column;
import com.systinet.persistence.tablemodel.Table;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class OracleSchemaHelper
extends DatabaseSchemaHelper {
    private static OracleBlobFieldSetter BLOB_FIELD_SETTER = new OracleBlobFieldSetter();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$systinet$persistence$tablemodel$Identity;

    protected String getSqlForBoolean() {
        return "NUMBER(1)";
    }

    protected String getSqlForByte() {
        return "SMALLINT";
    }

    protected String getSqlForLong() {
        return "NUMBER(20)";
    }

    protected String getSqlForFloat() {
        return "REAL";
    }

    protected String getSqlForDouble() {
        return "FLOAT";
    }

    protected void registerNonPrimitiveTypes() {
        this.registerTypeMapping(class$java$lang$String == null ? (class$java$lang$String = OracleSchemaHelper.class$("java.lang.String")) : class$java$lang$String, "VARCHAR2(" + this.getUsedStringLength() + ")");
        this.registerTypeMapping(class$com$systinet$persistence$tablemodel$Identity == null ? (class$com$systinet$persistence$tablemodel$Identity = OracleSchemaHelper.class$("com.systinet.persistence.tablemodel.Identity")) : class$com$systinet$persistence$tablemodel$Identity, "decimal(19)");
    }

    protected String processSearchTableName(String originalName) {
        return originalName.toUpperCase();
    }

    protected FieldSetterManager.FieldSetter getDefaultSetter() {
        return BLOB_FIELD_SETTER;
    }

    protected FieldSetterManager.FieldSetter getDefaultSetter(ClassLoader loader) {
        return new OracleBlobFieldSetterWithLoader(loader);
    }

    private String getIdentityColumn(Table table) {
        List columns = table.columns();
        Iterator iterator = columns.iterator();
        while (iterator.hasNext()) {
            Column column = (Column)iterator.next();
            if (!column.getJavaType().equals(class$com$systinet$persistence$tablemodel$Identity == null ? OracleSchemaHelper.class$("com.systinet.persistence.tablemodel.Identity") : class$com$systinet$persistence$tablemodel$Identity)) continue;
            return column.getName();
        }
        return null;
    }

    protected String[] createCreateTableCommands(Table table) {
        String identityColumn = this.getIdentityColumn(table);
        if (identityColumn == null) {
            return super.createCreateTableCommands(table);
        }
        String tableName = table.getName();
        String createTable = this.createCreateTableCommand(table);
        String createSequence = "CREATE SEQUENCE seq_" + tableName + " NOMAXVALUE";
        String createTrigger = "CREATE OR REPLACE TRIGGER inst_" + tableName + " BEFORE INSERT ON " + tableName + " FOR EACH ROW \nBEGIN IF :NEW." + identityColumn + " IS NULL THEN \n" + " SELECT seq_" + tableName + ".NEXTVAL INTO :NEW." + identityColumn + " FROM DUAL; \n" + " END IF; END;\n";
        return new String[]{createTable, createSequence, createTrigger};
    }

    protected String[] createDropTableCommands(Table table) {
        if (this.getIdentityColumn(table) == null) {
            return super.createDropTableCommands(table);
        }
        String tableName = table.getName();
        String dropTable = this.createDropTableCommand(tableName);
        String dropSequence = "DROP SEQUENCE seq_" + tableName;
        return new String[]{dropTable, dropSequence};
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OracleBlobFieldSetterWithLoader
    extends OracleBlobFieldSetter {
        private ClassLoader loader;

        public OracleBlobFieldSetterWithLoader(ClassLoader loader) {
            this.loader = loader;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            try {
                Blob blobLocator = source.getBlob(colIndex);
                if (blobLocator == null) {
                    field.set(instance, null);
                    return;
                }
                InputStream is = null;
                try {
                    is = blobLocator.getBinaryStream();
                    FieldSetterManager.ObjectInputStreamWithLoader ois = new FieldSetterManager.ObjectInputStreamWithLoader(is, this.loader);
                    Object value = ois.readObject();
                    field.set(instance, value);
                    Object var11_12 = null;
                    if (is == null) return;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (ClassNotFoundException cnfe) {
                throw new PersistenceException("Class to be deserialized not found: " + cnfe.getMessage(), cnfe);
            }
            catch (IOException ioe) {
                throw new PersistenceException("Error reading BLOB: " + ioe.getMessage(), ioe);
            }
        }
    }

    private static class OracleBlobFieldSetter
    implements FieldSetterManager.BySqlFieldSetter {
        private OracleBlobFieldSetter() {
        }

        public int forSqlType() {
            return 2004;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void setField(Field field, Object instance, ResultSet source, int colIndex, int sqlType) throws SQLException, IllegalAccessException, PersistenceException {
            try {
                Blob blobLocator = source.getBlob(colIndex);
                if (blobLocator == null) {
                    field.set(instance, null);
                    return;
                }
                InputStream is = null;
                try {
                    is = blobLocator.getBinaryStream();
                    ObjectInputStream ois = new ObjectInputStream(is);
                    Object value = ois.readObject();
                    field.set(instance, value);
                    Object var11_12 = null;
                    if (is == null) return;
                }
                catch (Throwable throwable) {
                    Object var11_13 = null;
                    if (is == null) throw throwable;
                    is.close();
                    throw throwable;
                }
                is.close();
                return;
            }
            catch (ClassNotFoundException cnfe) {
                throw new PersistenceException("Class to be deserialized not found: " + cnfe.getMessage(), cnfe);
            }
            catch (IOException ioe) {
                throw new PersistenceException("Error reading BLOB: " + ioe.getMessage(), ioe);
            }
        }

        public void setStatement(PreparedStatement pstmt, int colIndex, Field fromField, Object source) throws IllegalAccessException, SQLException, IllegalArgumentException, PersistenceException {
            Object obj = fromField.get(source);
            if (obj == null) {
                pstmt.setNull(colIndex, 2004);
                return;
            }
            try {
                AccessibleByteArrayOutputStream baos = new AccessibleByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(baos);
                oos.writeObject(obj);
                oos.close();
                pstmt.setBinaryStream(colIndex, (InputStream)new ByteArrayInputStream(baos.buf(), 0, baos.count()), baos.count());
            }
            catch (IOException ioe) {
                throw new PersistenceException("Cannot serialize a static class: " + ioe.getMessage(), ioe);
            }
        }

        private static class AccessibleByteArrayOutputStream
        extends ByteArrayOutputStream {
            private AccessibleByteArrayOutputStream() {
            }

            byte[] buf() {
                return this.buf;
            }

            int count() {
                return this.count;
            }
        }
    }
}

