/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.systinet.persistence.ClassParser;
import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceManager;
import com.systinet.persistence.PersistenceSqlException;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.PersistentField;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Set;

public class NestedAggregateQuery {
    private PersistentField field;
    private AggregateFunction function;

    NestedAggregateQuery(PersistentField field, AggregateFunction function) {
        if (field == null || function == null) {
            throw new NullPointerException("No parameter can be null");
        }
        this.field = field;
        this.function = function;
    }

    String toSql() {
        return "(" + this.toSqlWithoutBraces() + ")";
    }

    private String toSqlWithoutBraces() {
        return "SELECT " + this.function.sqlName() + "(" + (this.function == AggregateFunction.COUNT_DISTINCT ? "DISTINCT " : "") + this.field.name() + ")" + " FROM " + ClassParser.getTableNameFor(this.field.definedIn());
    }

    Expression.PreparedSql toPreparedSql() {
        return new Expression.PreparedSql(this.toSql(), Collections.EMPTY_LIST);
    }

    Set usedClasses() {
        return Collections.singleton(this.field.definedIn());
    }

    public Expression equal(long constant) {
        return new CompareAggregateExpression(PersistentField.ComparisonOperator.EQUAL, constant);
    }

    public Expression notEqual(long constant) {
        return new CompareAggregateExpression(PersistentField.ComparisonOperator.NOT_EQUAL, constant);
    }

    public Expression lessThan(long constant) {
        return new CompareAggregateExpression(PersistentField.ComparisonOperator.LESS, constant);
    }

    public Expression lessThanOrEqual(long constant) {
        return new CompareAggregateExpression(PersistentField.ComparisonOperator.LESS_EQUAL, constant);
    }

    public Expression greaterThan(long constant) {
        return new CompareAggregateExpression(PersistentField.ComparisonOperator.GREATER, constant);
    }

    public Expression greaterThanOrEqual(long constant) {
        return new CompareAggregateExpression(PersistentField.ComparisonOperator.GREATER_EQUAL, constant);
    }

    public long execute() throws PersistenceException {
        try {
            long l;
            TransactionManager txMgr;
            block6: {
                PersistenceManager pm = PersistenceManager.getInstance();
                txMgr = pm.getDatabase().getTransactionManager();
                txMgr.beginReadOnly();
                PreparedStatement pstmt = null;
                ConnectionMonitor conn = null;
                try {
                    conn = txMgr.getConnection();
                    pstmt = conn.prepareStatement(this.toSqlWithoutBraces());
                    ResultSet rs = pstmt.executeQuery();
                    rs.next();
                    l = rs.getLong(1);
                    Object var9_9 = null;
                    if (pstmt == null) break block6;
                }
                catch (Throwable throwable) {
                    Object var9_10 = null;
                    if (pstmt != null) {
                        conn.close(pstmt);
                    }
                    txMgr.end();
                    throw throwable;
                }
                conn.close(pstmt);
            }
            txMgr.end();
            return l;
        }
        catch (DatabaseCoreException e) {
            throw new PersistenceDbCoreException(e);
        }
        catch (SQLException e) {
            throw new PersistenceSqlException(e);
        }
    }

    private class CompareAggregateExpression
    extends Expression {
        private PersistentField.ComparisonOperator operator;
        private Constant constant;

        CompareAggregateExpression(PersistentField.ComparisonOperator operator, long constant) {
            if (operator == null) {
                throw new NullPointerException("operator may not be null");
            }
            this.operator = operator;
            this.constant = Constant.valueOf(constant);
        }

        String toSql() {
            return NestedAggregateQuery.this.toSql() + this.operator.sql() + this.constant.toSqlString();
        }

        Expression.PreparedSql toPreparedSql() {
            Expression.PreparedSql psql = NestedAggregateQuery.this.toPreparedSql();
            String sql = psql.sqlScript + this.operator.sql() + "?";
            return new Expression.PreparedSql(sql, Collections.singletonList(this.constant));
        }

        Set usedClasses() {
            return NestedAggregateQuery.this.usedClasses();
        }
    }

    static class AggregateFunction {
        public static final AggregateFunction COUNT_DISTINCT = new AggregateFunction("count");
        public static final AggregateFunction MIN = new AggregateFunction("min");
        public static final AggregateFunction MAX = new AggregateFunction("max");
        private final String sqlName;

        private AggregateFunction(String sqlName) {
            this.sqlName = sqlName;
        }

        public String sqlName() {
            return this.sqlName;
        }

        public String toString() {
            return this.sqlName();
        }
    }
}

