/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.systinet.persistence.query.PersistentField;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class OrderBy {
    private List fields = new ArrayList();
    private List orders = new ArrayList();
    private Set fieldSet = new HashSet();

    public void addAsc(PersistentField field) {
        this.checkField(field);
        this.fields.add(field);
        this.orders.add(OrderDirection.ASC);
    }

    public void addDesc(PersistentField field) {
        this.checkField(field);
        this.fields.add(field);
        this.orders.add(OrderDirection.DESC);
    }

    private void checkField(PersistentField field) {
        if (field == null) {
            throw new NullPointerException("Param 'field' must not be null");
        }
        if (this.fieldSet.contains(field)) {
            throw new IllegalArgumentException("Field " + field + " already in OrderBy");
        }
        this.fieldSet.add(field);
    }

    String toSql() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int limit = this.fields.size();
        while (i < limit) {
            PersistentField cpf = (PersistentField)this.fields.get(i);
            OrderDirection cod = (OrderDirection)this.orders.get(i);
            if (i != 0) {
                sb.append(", ");
            }
            sb.append(cpf.name());
            sb.append(' ');
            sb.append(cod);
            ++i;
        }
        if (sb.length() == 0) {
            return "1";
        }
        return sb.toString();
    }

    public String toString() {
        return this.toSql();
    }

    private static class OrderDirection {
        public static OrderDirection ASC = new OrderDirection("ASC");
        public static OrderDirection DESC = new OrderDirection("DESC");
        private String direction;

        private OrderDirection(String direction) {
            this.direction = direction;
        }

        public String toString() {
            return this.direction;
        }
    }
}

