/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.systinet.persistence.ClassParser;
import com.systinet.persistence.query.PersistentField;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;

public final class PersistentClass {
    private static Map classToInstance = new HashMap();
    private Class thisClass;
    private Map fields = new HashMap();

    public static PersistentClass getInstance(Class forClass) {
        PersistentClass instance = (PersistentClass)classToInstance.get(forClass);
        if (instance == null) {
            instance = new PersistentClass(forClass);
            classToInstance.put(forClass, instance);
        }
        return instance;
    }

    private PersistentClass(Class thisClass) {
        if (thisClass == null) {
            throw new NullPointerException("thisClass must not be null");
        }
        this.thisClass = thisClass;
        this.fields = new HashMap();
    }

    public String getName() {
        return ClassParser.getTableNameFor(this.thisClass);
    }

    public PersistentField field(String fieldName) {
        PersistentField pf = (PersistentField)this.fields.get(fieldName);
        if (pf == null) {
            Field jf;
            try {
                jf = this.thisClass.getField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException("Cannot find field " + fieldName + ": " + e.getMessage());
            }
            pf = new PersistentField(jf);
            this.fields.put(fieldName, pf);
        }
        return pf;
    }
}

