/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.query;

import com.systinet.persistence.ClassParser;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.NestedAggregateQuery;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PersistentField {
    private Field thisField;

    PersistentField(Field thisField) {
        if (!ClassParser.canBePersistentField(thisField)) {
            throw new IllegalArgumentException("Field '" + thisField + "' is transient.");
        }
        this.thisField = thisField;
    }

    Class type() {
        return this.thisField.getType();
    }

    public Class definedIn() {
        return this.thisField.getDeclaringClass();
    }

    public String name() {
        return this.thisField.getName();
    }

    public String toString() {
        return this.thisField.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PersistentField)) {
            return false;
        }
        PersistentField persistentField = (PersistentField)o;
        return this.thisField.equals(persistentField.thisField);
    }

    public int hashCode() {
        return this.thisField.hashCode();
    }

    public Expression equal(PersistentField rhs) {
        return new AtomicExpressionWithField(ComparisonOperator.EQUAL, this, rhs);
    }

    public Expression equal(Constant rhs) {
        if (rhs == Constant.NULL_CONSTANT) {
            return this.isNull();
        }
        return new AtomicExpressionWithConstant(ComparisonOperator.EQUAL, this, rhs);
    }

    public final Expression equal(String s) {
        return this.equal(Constant.valueOf(s));
    }

    public final Expression equal(Date d) {
        return this.equal(Constant.valueOf(d));
    }

    public final Expression equal(char c) {
        return this.equal(Constant.valueOf(c));
    }

    public final Expression equal(boolean b) {
        return this.equal(Constant.valueOf(b));
    }

    public final Expression equal(long l) {
        return this.equal(Constant.valueOf(l));
    }

    public final Expression equal(double d) {
        return this.equal(Constant.valueOf(d));
    }

    public Expression notEqual(PersistentField rhs) {
        return new AtomicExpressionWithField(ComparisonOperator.NOT_EQUAL, this, rhs);
    }

    public Expression notEqual(Constant rhs) {
        if (rhs == Constant.NULL_CONSTANT) {
            return this.isNotNull();
        }
        return new AtomicExpressionWithConstant(ComparisonOperator.NOT_EQUAL, this, rhs);
    }

    public final Expression notEqual(String s) {
        return this.notEqual(Constant.valueOf(s));
    }

    public final Expression notEqual(Date d) {
        return this.notEqual(Constant.valueOf(d));
    }

    public final Expression notEqual(char c) {
        return this.notEqual(Constant.valueOf(c));
    }

    public final Expression notEqual(boolean b) {
        return this.notEqual(Constant.valueOf(b));
    }

    public final Expression notEqual(long l) {
        return this.notEqual(Constant.valueOf(l));
    }

    public final Expression notEqual(double d) {
        return this.notEqual(Constant.valueOf(d));
    }

    public Expression greaterThan(PersistentField rhs) {
        return new AtomicExpressionWithField(ComparisonOperator.GREATER, this, rhs);
    }

    public Expression greaterThan(Constant rhs) {
        if (rhs == Constant.NULL_CONSTANT) {
            throw new NullPointerException("NULL not allowed in >");
        }
        return new AtomicExpressionWithConstant(ComparisonOperator.GREATER, this, rhs);
    }

    public final Expression greaterThan(String s) {
        return this.greaterThan(Constant.valueOf(s));
    }

    public final Expression greaterThan(Date d) {
        return this.greaterThan(Constant.valueOf(d));
    }

    public final Expression greaterThan(char c) {
        return this.greaterThan(Constant.valueOf(c));
    }

    public final Expression greaterThan(boolean b) {
        return this.greaterThan(Constant.valueOf(b));
    }

    public final Expression greaterThan(long l) {
        return this.greaterThan(Constant.valueOf(l));
    }

    public final Expression greaterThan(double d) {
        return this.greaterThan(Constant.valueOf(d));
    }

    public Expression greaterThanOrEqual(PersistentField rhs) {
        return new AtomicExpressionWithField(ComparisonOperator.GREATER_EQUAL, this, rhs);
    }

    public Expression greaterThanOrEqual(Constant rhs) {
        if (rhs == Constant.NULL_CONSTANT) {
            throw new NullPointerException("NULL not allowed in >=");
        }
        return new AtomicExpressionWithConstant(ComparisonOperator.GREATER_EQUAL, this, rhs);
    }

    public final Expression greaterThanOrEqual(String s) {
        return this.greaterThanOrEqual(Constant.valueOf(s));
    }

    public final Expression greaterThanOrEqual(Date d) {
        return this.greaterThanOrEqual(Constant.valueOf(d));
    }

    public final Expression greaterThanOrEqual(char c) {
        return this.greaterThanOrEqual(Constant.valueOf(c));
    }

    public final Expression greaterThanOrEqual(boolean b) {
        return this.greaterThanOrEqual(Constant.valueOf(b));
    }

    public final Expression greaterThanOrEqual(long l) {
        return this.greaterThanOrEqual(Constant.valueOf(l));
    }

    public final Expression greaterThanOrEqual(double d) {
        return this.greaterThanOrEqual(Constant.valueOf(d));
    }

    public Expression lessThan(PersistentField rhs) {
        return new AtomicExpressionWithField(ComparisonOperator.LESS, this, rhs);
    }

    public Expression lessThan(Constant rhs) {
        if (rhs == Constant.NULL_CONSTANT) {
            throw new NullPointerException("NULL not allowed in <");
        }
        return new AtomicExpressionWithConstant(ComparisonOperator.LESS, this, rhs);
    }

    public final Expression lessThan(String s) {
        return this.lessThan(Constant.valueOf(s));
    }

    public final Expression lessThan(Date d) {
        return this.lessThan(Constant.valueOf(d));
    }

    public final Expression lessThan(char c) {
        return this.lessThan(Constant.valueOf(c));
    }

    public final Expression lessThan(boolean b) {
        return this.lessThan(Constant.valueOf(b));
    }

    public final Expression lessThan(long l) {
        return this.lessThan(Constant.valueOf(l));
    }

    public final Expression lessThan(double d) {
        return this.lessThan(Constant.valueOf(d));
    }

    public Expression lessThanOrEqual(PersistentField rhs) {
        return new AtomicExpressionWithField(ComparisonOperator.LESS_EQUAL, this, rhs);
    }

    public Expression lessThanOrEqual(Constant rhs) {
        if (rhs == Constant.NULL_CONSTANT) {
            throw new NullPointerException("NULL not allowed in <=");
        }
        return new AtomicExpressionWithConstant(ComparisonOperator.LESS_EQUAL, this, rhs);
    }

    public final Expression lessThanOrEqual(String s) {
        return this.lessThanOrEqual(Constant.valueOf(s));
    }

    public final Expression lessThanOrEqual(Date d) {
        return this.lessThanOrEqual(Constant.valueOf(d));
    }

    public final Expression lessThanOrEqual(char c) {
        return this.lessThanOrEqual(Constant.valueOf(c));
    }

    public final Expression lessThanOrEqual(boolean b) {
        return this.lessThanOrEqual(Constant.valueOf(b));
    }

    public final Expression lessThanOrEqual(long l) {
        return this.lessThanOrEqual(Constant.valueOf(l));
    }

    public final Expression lessThanOrEqual(double d) {
        return this.lessThanOrEqual(Constant.valueOf(d));
    }

    public static String escapeLikePattern(String str) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        int limit = str.length();
        while (i < limit) {
            char ch = str.charAt(i);
            switch (ch) {
                case '%': 
                case '_': 
                case '|': {
                    sb.append('|');
                }
            }
            sb.append(ch);
            ++i;
        }
        return sb.toString();
    }

    public Expression like(String pattern) {
        return new LikeAtomicExpression(this, pattern, false);
    }

    public Expression notLike(String pattern) {
        return new LikeAtomicExpression(this, pattern, true);
    }

    public Expression isNull() {
        return new IsNullAtomicExpression(this, false);
    }

    public Expression isNotNull() {
        return new IsNullAtomicExpression(this, true);
    }

    public Expression between(Constant min, Constant max) {
        return new BetweenAtomicExpression(this, min, max);
    }

    public Expression between(String min, String max) {
        return this.between(Constant.valueOf(min), Constant.valueOf(max));
    }

    public Expression between(Date min, Date max) {
        return this.between(Constant.valueOf(min), Constant.valueOf(max));
    }

    public Expression between(char min, char max) {
        return this.between(Constant.valueOf(min), Constant.valueOf(max));
    }

    public Expression between(boolean min, boolean max) {
        return this.between(Constant.valueOf(min), Constant.valueOf(max));
    }

    public Expression between(long min, long max) {
        return this.between(Constant.valueOf(min), Constant.valueOf(max));
    }

    public Expression between(double min, double max) {
        return this.between(Constant.valueOf(min), Constant.valueOf(max));
    }

    public Expression equal(NestedAggregateQuery aggregate) {
        return new AtomicExpressionWithAggregate(ComparisonOperator.EQUAL, this, aggregate);
    }

    public Expression notEqual(NestedAggregateQuery aggregate) {
        return new AtomicExpressionWithAggregate(ComparisonOperator.NOT_EQUAL, this, aggregate);
    }

    public Expression lessThan(NestedAggregateQuery aggregate) {
        return new AtomicExpressionWithAggregate(ComparisonOperator.LESS, this, aggregate);
    }

    public Expression lessThanOrEqual(NestedAggregateQuery aggregate) {
        return new AtomicExpressionWithAggregate(ComparisonOperator.LESS_EQUAL, this, aggregate);
    }

    public Expression greaterThan(NestedAggregateQuery aggregate) {
        return new AtomicExpressionWithAggregate(ComparisonOperator.GREATER, this, aggregate);
    }

    public Expression greaterThanOrEqual(NestedAggregateQuery aggregate) {
        return new AtomicExpressionWithAggregate(ComparisonOperator.GREATER_EQUAL, this, aggregate);
    }

    public NestedAggregateQuery countDistinct() {
        return new NestedAggregateQuery(this, NestedAggregateQuery.AggregateFunction.COUNT_DISTINCT);
    }

    public NestedAggregateQuery max() {
        return new NestedAggregateQuery(this, NestedAggregateQuery.AggregateFunction.MAX);
    }

    public NestedAggregateQuery min() {
        return new NestedAggregateQuery(this, NestedAggregateQuery.AggregateFunction.MIN);
    }

    private static class AtomicExpressionWithAggregate
    extends AtomicExpression {
        private NestedAggregateQuery aggregate;

        AtomicExpressionWithAggregate(ComparisonOperator operator, PersistentField lhs, NestedAggregateQuery aggregate) {
            super(operator, lhs);
            if (aggregate == null) {
                throw new NullPointerException("aggregate must not be null");
            }
            this.aggregate = aggregate;
        }

        String toSql() {
            return this.lhs().name() + this.operator().sql() + this.aggregate.toSql();
        }

        Expression.PreparedSql toPreparedSql() {
            Expression.PreparedSql prepAggregate = this.aggregate.toPreparedSql();
            String sqlCmd = this.lhs().name() + this.operator().sql() + prepAggregate.sqlScript;
            return new Expression.PreparedSql(sqlCmd, prepAggregate.constants);
        }

        Set usedClasses() {
            HashSet<Class> uc = new HashSet<Class>(this.aggregate.usedClasses());
            uc.add(this.lhs().definedIn());
            return uc;
        }
    }

    private static class BetweenAtomicExpression
    extends Expression {
        private PersistentField field;
        private Constant min;
        private Constant max;

        public BetweenAtomicExpression(PersistentField field, Constant min, Constant max) {
            if (field == null || min == null || max == null) {
                throw new NullPointerException("No parameter can be null");
            }
            if (min.getClass() != max.getClass()) {
                throw new IllegalArgumentException("bounds must be compatible");
            }
            this.field = field;
            this.min = min;
            this.max = max;
        }

        String toSql() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.field.name());
            sb.append(" BETWEEN ");
            sb.append(this.min.toSqlString());
            sb.append(" AND ");
            sb.append(this.max.toSqlString());
            return sb.toString();
        }

        Expression.PreparedSql toPreparedSql() {
            String sqlCmd = this.field.name() + " BETWEEN ? AND ?";
            Constant[] consts = new Constant[]{this.min, this.max};
            return new Expression.PreparedSql(sqlCmd, Arrays.asList(consts));
        }

        Set usedClasses() {
            return Collections.singleton(this.field.definedIn());
        }
    }

    private static class IsNullAtomicExpression
    extends Expression {
        private PersistentField field;
        private boolean negate;

        IsNullAtomicExpression(PersistentField field, boolean negate) {
            this.field = field;
            this.negate = negate;
        }

        String toSql() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.field.name());
            sb.append(" IS ");
            if (this.negate) {
                sb.append("NOT ");
            }
            sb.append("NULL");
            return sb.toString();
        }

        Expression.PreparedSql toPreparedSql() {
            return new Expression.PreparedSql(this.toSql(), Collections.EMPTY_LIST);
        }

        Set usedClasses() {
            return Collections.singleton(this.field.definedIn());
        }
    }

    private static class LikeAtomicExpression
    extends Expression {
        private PersistentField field;
        private String pattern;
        private boolean negate;

        LikeAtomicExpression(PersistentField field, String pattern, boolean negate) {
            if (field == null || pattern == null) {
                throw new NullPointerException("No param can be null");
            }
            this.field = field;
            this.pattern = pattern;
            this.negate = negate;
        }

        String toSql() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.field.name());
            if (this.negate) {
                sb.append(" NOT ");
            }
            sb.append(" LIKE ");
            sb.append('\'');
            sb.append(this.escapeApostrophe(this.pattern));
            sb.append('\'');
            sb.append(" ESCAPE '|'");
            return sb.toString();
        }

        Expression.PreparedSql toPreparedSql() {
            StringBuffer sql = new StringBuffer();
            sql.append(this.field.name());
            if (this.negate) {
                sql.append(" NOT ");
            }
            sql.append(" LIKE ? ESCAPE '|'");
            List<Constant> c = Collections.singletonList(Constant.valueOf(this.pattern));
            return new Expression.PreparedSql(sql.toString(), c);
        }

        private String escapeApostrophe(String str) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            int limit = str.length();
            while (i < limit) {
                char ch = str.charAt(i);
                if (ch == '\'') {
                    sb.append('\'');
                }
                sb.append(ch);
                ++i;
            }
            return sb.toString();
        }

        Set usedClasses() {
            return Collections.singleton(this.field.definedIn());
        }
    }

    private static class AtomicExpressionWithConstant
    extends AtomicExpression {
        private Constant rhs;

        public AtomicExpressionWithConstant(ComparisonOperator operator, PersistentField lhs, Constant rhs) {
            super(operator, lhs);
            this.rhs = rhs;
        }

        public String toSql() {
            return this.lhs().name() + " " + this.operator().sql() + " " + this.rhs.toSqlString();
        }

        Expression.PreparedSql toPreparedSql() {
            return new Expression.PreparedSql(this.lhs().name() + " " + this.operator().sql() + " " + this.rhs.getPrepStmtString(), Collections.singletonList(this.rhs));
        }

        public Set usedClasses() {
            return Collections.singleton(this.lhs().definedIn());
        }
    }

    private static class AtomicExpressionWithField
    extends AtomicExpression {
        private PersistentField rhs;

        AtomicExpressionWithField(ComparisonOperator operator, PersistentField lhs, PersistentField rhs) {
            super(operator, lhs);
            this.rhs = rhs;
        }

        String toSql() {
            return this.lhs().name() + " " + this.operator().sql() + " " + this.rhs.name();
        }

        Expression.PreparedSql toPreparedSql() {
            return new Expression.PreparedSql(this.toSql(), Collections.EMPTY_LIST);
        }

        Set usedClasses() {
            HashSet<Class> r = new HashSet<Class>(4);
            r.add(this.lhs().definedIn());
            r.add(this.rhs.definedIn());
            return r;
        }
    }

    private static abstract class AtomicExpression
    extends Expression {
        private ComparisonOperator operator;
        private PersistentField lhs;

        AtomicExpression(ComparisonOperator operator, PersistentField lhs) {
            if (operator == null || lhs == null) {
                throw new NullPointerException("Neither operator nor lhs may be null");
            }
            this.operator = operator;
            this.lhs = lhs;
        }

        final ComparisonOperator operator() {
            return this.operator;
        }

        final PersistentField lhs() {
            return this.lhs;
        }
    }

    static class ComparisonOperator {
        public static final ComparisonOperator EQUAL = new ComparisonOperator("EQUAL", "=");
        public static final ComparisonOperator NOT_EQUAL = new ComparisonOperator("NOT_EQUAL", "<>");
        public static final ComparisonOperator GREATER = new ComparisonOperator("GREATER", ">");
        public static final ComparisonOperator GREATER_EQUAL = new ComparisonOperator("GREATER_EQUAL", ">=");
        public static final ComparisonOperator LESS = new ComparisonOperator("LESS", "<");
        public static final ComparisonOperator LESS_EQUAL = new ComparisonOperator("LESS_EQUAL", "<=");
        private final String myName;
        private final String sql;

        private ComparisonOperator(String name, String sql) {
            this.myName = name;
            this.sql = sql;
        }

        public String toString() {
            return this.myName;
        }

        public String sql() {
            return this.sql;
        }
    }
}

