/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.persistence.waspmodule;

import com.idoox.debug.Category;
import com.systinet.uddi.config.ConfigHelper;
import com.systinet.uddi.config.ConfigurationException;
import com.systinet.uddi.database.ApiManager;
import com.systinet.uddi.database.DatabaseCoreException;
import org.idoox.config.Configurable;
import org.idoox.wasp.Module;
import org.idoox.wasp.WaspInternalException;
import org.systinet.wasp.Wasp;

public class DbPersistenceWaspModule
implements Module {
    private static final Category log = Category.getCategory((String)"com.systinet.persistence.waspmodule.DbPersistenceWaspModule");
    private static final String CONFIG_FILE = "database.xml";
    private static final String CONFIG_SUBDIR = "conf";
    private static final String CONFIG_FAIL_MSG = "Cannot load db_core configuration";
    private static final String CONFIG_DIR_PROPERTY = "wasp.db.config.dir";

    public void load(Configurable configurable) throws WaspInternalException {
        String separator = System.getProperty("file.separator");
        String configDir = System.getProperty(CONFIG_DIR_PROPERTY);
        if (configDir == null) {
            String waspLocation = Wasp.getWaspLocation();
            if (waspLocation.startsWith("file:")) {
                waspLocation = waspLocation.substring("file:".length());
            }
            configDir = waspLocation + separator + CONFIG_SUBDIR;
        }
        try {
            ConfigHelper.init(configDir, CONFIG_FILE);
        }
        catch (ConfigurationException e) {
            log.error(CONFIG_FAIL_MSG, (Throwable)((Object)e));
            throw new WaspInternalException(CONFIG_FAIL_MSG, (Throwable)((Object)e));
        }
        log.info("Db_core configuration loaded from " + configDir + separator + CONFIG_FILE);
    }

    public void init() throws WaspInternalException {
    }

    public void destroy() {
        try {
            if (ApiManager.anyApiManagerUsed()) {
                ApiManager.getApiManager().getDatabase().shutdown();
                log.info("Db_core component shutdown correctly");
            } else {
                log.info("Db_core component was not used");
            }
        }
        catch (DatabaseCoreException e) {
            log.error("Cannot shutdown db_core", (Throwable)((Object)e));
        }
        ConfigHelper.destroy();
    }
}

