/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.config;

import com.idoox.config.xml.XMLConfigurator;
import com.idoox.debug.Category;
import com.systinet.uddi.config.ConfigHolder;
import com.systinet.uddi.config.ConfigInfo;
import com.systinet.uddi.config.ConfigReloadEvent;
import com.systinet.uddi.config.ConfigurationException;
import com.systinet.uddi.config.FlushDaemon;
import com.systinet.uddi.config.UDDIConfigReference;
import com.systinet.uddi.util.ApplicationCoreBundle;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.idoox.config.Configurable;
import org.idoox.config.IConfigurator;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventManager;

public class ConfigHelper {
    private static final Category log = Category.getCategory((String)"application_core:com.systinet.uddi.config.ConfigHelper");
    private static final int DEFAULT_SAVING_PERIOD = 2000;
    private static Map configurations = null;
    private static Timer timer;
    private static String configDirectory;
    static /* synthetic */ Class class$com$systinet$uddi$config$UDDIConfigReference;
    static /* synthetic */ Class class$com$systinet$uddi$config$ConfigHelper$Config;

    public static synchronized void init(String configDirectory) throws ConfigurationException {
        ConfigHelper.init(configDirectory, null);
    }

    public static synchronized void init(String configDirectory, String configFile) throws ConfigurationException {
        configurations = new HashMap();
        ConfigHelper.addConfig(configDirectory, configFile);
        Runtime.getRuntime().addShutdownHook(new HookThread());
        ConfigHelper.configDirectory = configDirectory;
    }

    public static String getConfigDirectory() {
        return configDirectory;
    }

    public static synchronized void init(Configurable serviceConfigurable) throws ConfigurationException {
        Configurable parent = serviceConfigurable.getParent();
        UDDIConfigReference configReference = (UDDIConfigReference)parent.narrow(class$com$systinet$uddi$config$UDDIConfigReference == null ? (class$com$systinet$uddi$config$UDDIConfigReference = ConfigHelper.class$("com.systinet.uddi.config.UDDIConfigReference")) : class$com$systinet$uddi$config$UDDIConfigReference);
        String configDirURI = serviceConfigurable.getReferenceLocation();
        String configDir = configDirURI.substring("file:".length());
        ConfigHelper.init(configDir + "/" + configReference.getUddiConfigDir(), null);
    }

    public static synchronized void init() throws ConfigurationException {
        throw new ConfigurationException(11012, ApplicationCoreBundle.getString("ERROR_11012_ConfigurationNotLoaded"));
    }

    public static void destroy() {
        if (timer != null) {
            timer.cancel();
            timer = null;
        }
        if (configurations != null) {
            Iterator i = configurations.values().iterator();
            while (i.hasNext()) {
                ConfigHolder holder = (ConfigHolder)i.next();
                holder.configurator.flush();
            }
            configurations = null;
        }
    }

    public static IConfigurator getConfigurator(String configName) throws ConfigurationException {
        ConfigHolder holder;
        if (configurations == null) {
            ConfigHelper.init();
        }
        if ((holder = (ConfigHolder)configurations.get(configName)) == null) {
            throw new ConfigurationException(11001, ApplicationCoreBundle.getString("ERROR_11001_ConfigNotFound_P1", configName));
        }
        return holder.configurator;
    }

    public static IConfigurator[] getConfigurators() throws ConfigurationException {
        if (configurations == null) {
            ConfigHelper.init();
        }
        IConfigurator[] result = new IConfigurator[configurations.size()];
        int index = 0;
        Iterator i = configurations.values().iterator();
        while (i.hasNext()) {
            ConfigHolder holder = (ConfigHolder)i.next();
            result[index++] = holder.configurator;
        }
        return result;
    }

    public static Configurable getConfigurable(String configName) throws ConfigurationException {
        ConfigHolder holder;
        if (configurations == null) {
            ConfigHelper.init();
        }
        if ((holder = (ConfigHolder)configurations.get(configName)) == null) {
            throw new ConfigurationException(11001, ApplicationCoreBundle.getString("ERROR_11001_ConfigNotFound_P1", configName));
        }
        if (holder.configurable == null) {
            holder.configurable = holder.configurator.getConfigurable("config", configName);
        }
        return holder.configurable;
    }

    public static String[] getConfigNames() throws ConfigurationException {
        if (configurations == null) {
            ConfigHelper.init();
        }
        return configurations.keySet().toArray(new String[configurations.keySet().size()]);
    }

    public static ConfigInfo getConfigInfo(String configName) throws ConfigurationException {
        ConfigHolder holder;
        if (configurations == null) {
            ConfigHelper.init();
        }
        if ((holder = (ConfigHolder)configurations.get(configName)) == null) {
            throw new ConfigurationException(11001, ApplicationCoreBundle.getString("ERROR_11001_ConfigNotFound_P1", configName));
        }
        return holder.configInfo;
    }

    public static ConfigInfo[] getConfigInfos() throws ConfigurationException {
        if (configurations == null) {
            ConfigHelper.init();
        }
        ConfigInfo[] result = new ConfigInfo[configurations.size()];
        int index = 0;
        Iterator i = configurations.values().iterator();
        while (i.hasNext()) {
            ConfigHolder holder = (ConfigHolder)i.next();
            result[index++] = holder.configInfo;
        }
        return result;
    }

    public static void reload(String configName) throws ConfigurationException {
        ConfigHolder config;
        if (configurations == null) {
            ConfigHelper.init();
        }
        if ((config = (ConfigHolder)configurations.get(configName)) == null) {
            throw new ConfigurationException(11001, ApplicationCoreBundle.getString("ERROR_11001_ConfigNotFound_P1", configName));
        }
        config.configurator.flush();
        ConfigReloadEvent event = new ConfigReloadEvent(configName);
        EventManager.fireEvent((Event)event);
    }

    public static void reload() throws ConfigurationException {
        if (configurations == null) {
            ConfigHelper.init();
        }
        String[] names = new String[configurations.values().size()];
        int nameIndex = 0;
        Iterator i = configurations.values().iterator();
        while (i.hasNext()) {
            ConfigHolder holder = (ConfigHolder)i.next();
            holder.configurator.flush();
            names[nameIndex++] = holder.configInfo.getConfigName();
        }
        ConfigReloadEvent event = new ConfigReloadEvent(names);
        EventManager.fireEvent((Event)event);
    }

    public static void addConfig(String configDirectory, String configFile) throws ConfigurationException {
        File[] files;
        File configDir = new File(configDirectory);
        if (!configDir.isDirectory() || !configDir.canRead()) {
            throw new ConfigurationException(11002, ApplicationCoreBundle.getString("ERROR_11002_CantReadConfigDir_P1", configDir.toString()));
        }
        if (configFile != null) {
            files = new File[]{new File(configFile)};
        } else {
            File[] allFiles = configDir.listFiles();
            ArrayList<File> fileList = new ArrayList<File>();
            int i = 0;
            while (i < allFiles.length) {
                if (allFiles[i].getName().endsWith(".xml")) {
                    fileList.add(allFiles[i]);
                }
                ++i;
            }
            files = fileList.toArray(new File[fileList.size()]);
        }
        int i = 0;
        while (i < files.length) {
            HashMap<String, String> initParm = new HashMap<String, String>();
            initParm.put("wasp.location", configDir.getAbsolutePath());
            initParm.put("wasp.config.location", files[i].getName());
            log.debug("Loading configuration " + files[i].getName() + " from " + configDir);
            XMLConfigurator configurator = new XMLConfigurator();
            configurator.init(initParm);
            Configurable[] c = configurator.getTopEntries("config");
            if (c != null && c.length != 0) {
                boolean local;
                int savingPeriod;
                String configName;
                Config config = (Config)c[0].narrow(class$com$systinet$uddi$config$ConfigHelper$Config == null ? ConfigHelper.class$("com.systinet.uddi.config.ConfigHelper$Config") : class$com$systinet$uddi$config$ConfigHelper$Config);
                ConfigHolder holder = new ConfigHolder();
                try {
                    configName = config.getName();
                }
                catch (Exception e) {
                    throw new ConfigurationException(11003, e);
                }
                if (configurations.containsKey(configName)) {
                    throw new ConfigurationException(11004, ApplicationCoreBundle.getString("ERROR_11004_DuplicateConfigurationName_P1", configName));
                }
                holder.configurator = configurator;
                try {
                    savingPeriod = config.getSavingPeriod();
                }
                catch (Exception e) {
                    savingPeriod = 2000;
                }
                try {
                    local = config.getLocal();
                }
                catch (Exception e) {
                    local = false;
                }
                holder.configInfo = new ConfigInfo(configName, files[i], local, savingPeriod);
                configurations.put(configName, holder);
                if (savingPeriod == 0) {
                    return;
                }
                if (timer == null) {
                    timer = new Timer(true);
                }
                timer.scheduleAtFixedRate((TimerTask)new FlushDaemon((IConfigurator)configurator), 0L, (long)savingPeriod);
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class HookThread
    extends Thread {
        private HookThread() {
        }

        public void run() {
            this.setName("Config Shutdown");
            if (configurations != null) {
                Iterator i = configurations.values().iterator();
                while (i.hasNext()) {
                    ConfigHolder holder = (ConfigHolder)i.next();
                    holder.configurator.flush();
                }
            }
        }
    }

    public static interface Config {
        public int getSavingPeriod();

        public void setSavingPeriod();

        public boolean getLocal();

        public void setLocal(boolean var1);

        public String getName();
    }
}

