/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.database.CheckStatements;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.PreparedStatementCache;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class ConnectionMonitor {
    private Connection conn;
    private PreparedStatementCache pstmtCache;
    private CheckStatements cs;
    private static final Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.ConnectionMonitor");

    public ConnectionMonitor(Connection conn) {
        this(conn, null);
    }

    ConnectionMonitor(Connection conn, PreparedStatementCache pstmtCache) {
        this.conn = conn;
        this.pstmtCache = pstmtCache;
        this.cs = new CheckStatements();
    }

    public Statement createStatement() throws SQLException, DatabaseCoreException {
        this.check();
        Statement stmt = this.conn.createStatement();
        this.cs.addStatement(stmt);
        return stmt;
    }

    public Statement createScrollableStatement() throws SQLException, DatabaseCoreException {
        this.check();
        Statement stmt = this.conn.createStatement(1004, 1007);
        this.cs.addStatement(stmt);
        return stmt;
    }

    public Statement createUpdatableStatement() throws SQLException, DatabaseCoreException {
        this.check();
        Statement stmt = this.conn.createStatement(1005, 1008);
        this.cs.addStatement(stmt);
        return stmt;
    }

    public PreparedStatement prepareStatement(String sql) throws SQLException, DatabaseCoreException {
        this.check();
        log.debug("prepareStatement..." + sql + "");
        PreparedStatement stmt = null;
        stmt = this.pstmtCache != null ? this.pstmtCache.getPreparedStatement(this.conn, sql) : this.conn.prepareStatement(sql);
        this.cs.addStatement(stmt);
        return stmt;
    }

    protected void commit() throws SQLException, DatabaseCoreException {
        this.check();
        this.cs.checkUnclosedStatements();
        this.conn.commit();
    }

    protected void rollback() throws SQLException, DatabaseCoreException {
        this.check();
        this.cs.checkUnclosedStatements();
        this.conn.rollback();
    }

    protected void invalidateConnection() {
        this.conn = null;
    }

    protected void check() throws DatabaseCoreException {
        if (this.conn == null) {
            throw new DatabaseCoreException(12031, DatabaseCoreBundle.getString("ERROR_12031_NoTransaction"));
        }
    }

    public void close(Statement stmt) throws SQLException, DatabaseCoreException {
        this.check();
        log.debug("Close ... Statement");
        this.cs.removeStatement(stmt);
        stmt.close();
    }

    protected Connection getUnderliedConnection() throws DatabaseCoreException {
        this.check();
        return this.conn;
    }

    public int executeUpdate(PreparedStatement stmt) throws SQLException, DatabaseCoreException {
        this.check();
        try {
            log.debug("executeUpdate(maxRows=" + stmt.getMaxRows() + ")");
            long t1 = System.currentTimeMillis();
            int result = stmt.executeUpdate();
            long t2 = System.currentTimeMillis();
            log.debug("executeUpdate OK... " + new Integer(result).toString() + " rows : TIME=" + (t2 - t1));
            return result;
        }
        catch (SQLException e) {
            log.debug("executeUpdate FAILED: executeUpdate # " + e.getErrorCode() + " : " + e.getSQLState(), (Throwable)e);
            throw e;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int executeUpdate(String update) throws SQLException, DatabaseCoreException {
        int n;
        this.check();
        Statement stmt = null;
        try {
            try {
                log.debug("executeUpdate(" + update + ")");
                stmt = this.createStatement();
                long t1 = System.currentTimeMillis();
                int result = stmt.executeUpdate(update);
                long t2 = System.currentTimeMillis();
                log.debug("executeUpdate OK... " + result + " rows, TIME=" + (t2 - t1));
                n = result;
                Object var10_8 = null;
                if (stmt == null) return n;
            }
            catch (SQLException e) {
                log.error("executeUpdate FAILED: executeUpdate \"" + update + "\" # " + e.getErrorCode() + " : " + e.getSQLState(), (Throwable)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (stmt == null) throw throwable;
            this.close(stmt);
            throw throwable;
        }
        this.close(stmt);
        return n;
    }

    public ResultSet executeQuery(PreparedStatement stmt) throws SQLException, DatabaseCoreException {
        this.check();
        try {
            log.debug("executeQuery( maxRows=" + stmt.getMaxRows() + ")");
            long t1 = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery();
            long t2 = System.currentTimeMillis();
            log.debug("executeQueryPreparedStatement OK... TIME=" + (t2 - t1));
            return rs;
        }
        catch (SQLException e) {
            log.debug("executeQuery FAILED: executeQuery", (Throwable)e);
            throw e;
        }
    }

    public ResultSet executeQuery(Statement stmt, String query) throws SQLException, DatabaseCoreException {
        this.check();
        try {
            log.debug("executeQuery( maxRows=" + stmt.getMaxRows() + ", sql=" + query);
            long t1 = System.currentTimeMillis();
            ResultSet rs = stmt.executeQuery(query);
            long t2 = System.currentTimeMillis();
            log.debug("executeQueryStatement OK... TIME=" + (t2 - t1));
            return rs;
        }
        catch (SQLException e) {
            log.debug("executeQuery FAILED: executeQuery", (Throwable)e);
            throw e;
        }
    }

    public DatabaseMetaData getMetaData() throws SQLException, DatabaseCoreException {
        this.check();
        return this.conn.getMetaData();
    }
}

