/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ConfigurableDriver;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.Driver;
import com.systinet.uddi.database.config.DriverProperty;
import java.sql.Connection;
import java.sql.SQLException;

public class DriverManager
implements Driver {
    private Driver driver = null;
    private boolean initialized = false;
    private String errorMessage = null;
    private int errorCode;
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.DriverManager");

    public synchronized Connection getConnection() throws SQLException, DatabaseCoreException {
        if (!this.initialized) {
            throw new DatabaseCoreException(this.errorCode, this.errorMessage);
        }
        return this.driver.getConnection();
    }

    public synchronized String getDummyQuery() {
        return this.initialized ? this.driver.getDummyQuery() : this.errorMessage;
    }

    public void init(String driverClassName, DriverProperty dp) throws DatabaseCoreException {
        this.init(driverClassName, dp.getHostname(), dp.getPort(), dp.getDbName(), dp.getUserName(), dp.getUserPassword());
    }

    public synchronized void init(String driverClassName, String hostName, int port, String dbName, String userName, String userPassword) throws DatabaseCoreException {
        try {
            this.initialized = false;
            this.driver = (Driver)Class.forName(driverClassName).newInstance();
            if (this.driver instanceof ConfigurableDriver) {
                ((ConfigurableDriver)this.driver).init(hostName, port, dbName, userName, userPassword);
            }
            this.initialized = true;
        }
        catch (ClassNotFoundException e) {
            this.errorCode = 12011;
            this.errorMessage = DatabaseCoreBundle.getString("ERROR_12011_DriverNotFound_P1", driverClassName);
            log.error("( " + this.errorCode + " ) " + this.errorMessage, (Throwable)e);
            throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
        }
        catch (InstantiationException e) {
            this.errorCode = 12012;
            this.errorMessage = DatabaseCoreBundle.getString("ERROR_12012_DriverInstantiation_P1", driverClassName);
            log.error("( " + this.errorCode + " ) " + this.errorMessage, (Throwable)e);
            throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
        }
        catch (IllegalAccessException e) {
            this.errorCode = 12013;
            this.errorMessage = DatabaseCoreBundle.getString("ERROR_12013_DriverIllegalAccess_P1", driverClassName);
            log.error("( " + this.errorCode + " ) " + this.errorMessage, (Throwable)e);
            throw new DatabaseCoreException(this.errorCode, this.errorMessage, e);
        }
    }
}

