/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database;

import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import java.util.Vector;

class TransactionInfo {
    static long id = 0L;
    static Object lock = new Object();
    Vector nesting = new Vector();
    boolean rollback = false;
    long currentId;
    private static final String READONLY = "READONLY";
    private static final String READWRITE = "READWRITE";

    public TransactionInfo() {
        Object object = lock;
        synchronized (object) {
            this.currentId = id++;
        }
    }

    public int getDeep() {
        return this.nesting.size();
    }

    public void beginReadOnly() {
        this.nesting.add(READONLY);
    }

    public void end() throws DatabaseCoreException {
        this.removeType(READONLY);
    }

    public void beginReadWrite() {
        this.nesting.add(READWRITE);
    }

    public void commit() throws DatabaseCoreException {
        this.removeType(READWRITE);
        if (this.rollback) {
            throw new DatabaseCoreException(12033, DatabaseCoreBundle.getString("ERROR_12033_CommitRolback"));
        }
    }

    public void rollback() throws DatabaseCoreException {
        this.removeType(READWRITE);
        this.rollback = true;
    }

    public long getTransactionId() {
        return this.currentId;
    }

    private void removeType(String expectedType) throws DatabaseCoreException {
        String type = (String)this.nesting.remove(this.nesting.size() - 1);
        if (!type.equals(expectedType)) {
            throw new DatabaseCoreException(12034, DatabaseCoreBundle.getString("ERROR_12034_EndTransaction"));
        }
    }

    public String toString() {
        return "TransactionInfo: nesting=" + this.nesting + ", rollback=" + this.rollback + ", currentId=" + this.currentId;
    }
}

