/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database.mssql;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ConfigurableDriver;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Hashtable;
import java.util.Properties;

public class OptaDriver
extends ConfigurableDriver {
    private static Category log = Category.getCategory((String)"database_core.com.systinet.uddi.database.mssql.OptaDriver");
    private static final String jdbcDriverClassName = "com.inet.pool.PoolDriver";
    private static final String jdbcDriverName = "inetpool:inetdae7";
    private static Object jdbcDriver = null;
    private static final String MSSQL_DUMMY_QUERY = "SELECT 1";

    public synchronized void init(String hostName, int port, String dbName, String user, String password) throws DatabaseCoreException {
        super.init(hostName, port, dbName, user, password);
        try {
            if (jdbcDriver == null) {
                jdbcDriver = Class.forName(jdbcDriverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseCoreException(12001, DatabaseCoreBundle.getString("ERROR_12001_JdbcDriverNotFound_P2", new String[]{"MS SQL", jdbcDriverClassName}), e);
        }
    }

    public Connection getConnection() throws SQLException {
        String connectionAddress = "jdbc:inetpool:inetdae7:" + this.hostName + ":" + this.port + "?database=" + this.dbName + "&sql7=true";
        log.debug(connectionAddress + " user:" + this.user + " password:" + this.password);
        Properties properties = new Properties();
        ((Hashtable)properties).put("user", this.user);
        if (this.password != null) {
            ((Hashtable)properties).put("password", this.password);
        }
        ((Hashtable)properties).put("charSet", "UTF8");
        Connection conn = DriverManager.getConnection(connectionAddress, properties);
        return conn;
    }

    public String getDummyQuery() {
        return MSSQL_DUMMY_QUERY;
    }
}

