/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.uddi.database.mysql;

import com.idoox.debug.Category;
import com.systinet.uddi.database.ConfigurableDriver;
import com.systinet.uddi.database.DatabaseCoreBundle;
import com.systinet.uddi.database.DatabaseCoreException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class MySqlDriver
extends ConfigurableDriver {
    private static Category log = Category.getCategory((String)"com.systinet.uddi.database.mysql.MySqlDriver");
    private static final String jdbcDriverClassName = "com.mysql.jdbc.Driver";
    private static final String jdbcDriverName = "mysql";
    private static Object jdbcDriver = null;
    private static final String MYSQL_DUMMY_QUERY = "SELECT 1";

    public synchronized void init(String hostName, int port, String dbName, String user, String password) throws DatabaseCoreException {
        super.init(hostName, port, dbName, user, password);
        try {
            if (jdbcDriver == null) {
                jdbcDriver = Class.forName(jdbcDriverClassName);
            }
        }
        catch (ClassNotFoundException e) {
            throw new DatabaseCoreException(12001, DatabaseCoreBundle.getString("ERROR_12001_JdbcDriverNotFound_P2", new String[]{"MySQL", jdbcDriverClassName}), e);
        }
    }

    public Connection getConnection() throws SQLException {
        String connectionAddress = "jdbc:mysql://" + this.hostName + ":" + this.port + "/" + this.dbName + "?user=" + this.user + "&password=" + this.password;
        log.debug(connectionAddress);
        Connection conn = DriverManager.getConnection(connectionAddress);
        return conn;
    }

    public String getDummyQuery() {
        return MYSQL_DUMMY_QUERY;
    }
}

