/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin.interceptor;

import java.io.IOException;
import java.util.Hashtable;
import org.idoox.config.Configurable;
import org.idoox.transport.Connection;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.OutputMessageWrapper;
import org.idoox.wasp.interceptor.InterceptorChain;
import org.idoox.wasp.interceptor.TransportInterceptor;
import org.systinet.wasp.admin.ServiceEndpointPerformanceLog;

public class PerformanceInterceptor
implements TransportInterceptor {
    public static Hashtable recordMap = new Hashtable();

    public void load(Configurable config) {
    }

    public void destroy() {
    }

    public void intercept(Connection connection, InterceptorChain chain, int position) {
        String path = connection.getURI().getPath();
        long alarm = 0L;
        if (connection.getInputMessage() != null) {
            alarm = System.currentTimeMillis();
            connection.setInputMessage(connection.getInputMessage());
        }
        if (connection.getOutputMessage() != null) {
            connection.setOutputMessage((OutputMessage)new PerformanceOutputMessage(connection.getOutputMessage(), alarm, path));
        }
    }

    public static void resetRecord(String endpointPath) {
        PerformanceInterceptor.addRecord(endpointPath);
    }

    public static void addRecord(String endpointPath) {
        recordMap.put(endpointPath, new ServiceEndpointPerformanceLog());
    }

    public static ServiceEndpointPerformanceLog getRecord(String endpointPath) {
        return (ServiceEndpointPerformanceLog)recordMap.get(endpointPath);
    }

    public static void removeRecord(String endpointPath) {
        recordMap.remove(endpointPath);
    }

    class PerformanceOutputMessage
    extends OutputMessageWrapper {
        private ServiceEndpointPerformanceLog record = null;
        private long alarm = 0L;
        private String path;

        public PerformanceOutputMessage(OutputMessage message, long alarm, String path) {
            super(message);
            this.alarm = alarm;
            this.path = path;
        }

        public void write(byte[] b) throws IOException {
            super.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
        }

        public void write(int b) throws IOException {
            super.write(b);
        }

        public void close() throws IOException {
            super.close();
            Hashtable hashtable = recordMap;
            synchronized (hashtable) {
                ServiceEndpointPerformanceLog record = (ServiceEndpointPerformanceLog)recordMap.get(this.path);
                if (record == null) {
                    record = new ServiceEndpointPerformanceLog();
                    recordMap.put(this.path, record);
                }
                long dif = System.currentTimeMillis() - this.alarm;
                record.update(dif);
            }
        }
    }
}

