/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.admin.utils;

import com.idoox.wasp.server.config.ServiceBindingConfig;
import com.idoox.wasp.server.config.ServiceInstanceConfig;
import com.systinet.wasp.dd.DescriptorConverter;
import java.util.HashMap;
import org.idoox.config.Configurable;
import org.idoox.config.IConfigurator;
import org.systinet.wasp.Version;
import org.systinet.wasp.admin.AdminServiceException;
import org.systinet.wasp.admin.InterceptorInfo;
import org.systinet.wasp.admin.IpFilterInfo;
import org.systinet.wasp.admin.IpFilterRule;
import org.systinet.wasp.admin.Package;
import org.systinet.wasp.admin.ServiceEndpoint;
import org.systinet.wasp.admin.ServiceEndpointInfo;
import org.systinet.wasp.admin.ServiceInstance;
import org.systinet.wasp.admin.ServiceInstanceInfo;
import org.systinet.wasp.mgmt.ServiceAdministration;

public class ConfigServiceAdministration
implements ServiceAdministration {
    private static final String SERVICE_INSTANCE = "ServiceInstance";
    private static final String POST_SERVICE_ENDPOINT = "ServiceBinding";
    private static final String GET_SERVICE_ENDPOINT = "GetServiceBinding";
    private static final boolean CHECK_GET_SERVICE_ENDPOINTS = true;
    private IConfigurator configurator;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceInstanceConfig;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceBindingConfig;

    public ConfigServiceAdministration(IConfigurator configurator) {
        this.configurator = configurator;
    }

    private static String encodeServiceInstance(ServiceInstance serviceInstance) {
        return DescriptorConverter.encodeName((String)serviceInstance.context, (String)serviceInstance.targetNamespace, (String)serviceInstance.name);
    }

    public org.systinet.wasp.admin.Version getServerVersion() {
        return new org.systinet.wasp.admin.Version("WASP", "Systinet Server for Java", "SSJ-5.5-20041128-1204", "5.5", "5.5", Version.javaVersion, Version.osName, Version.osVersion);
    }

    public ServiceInstanceInfo[] getServiceInstances() throws AdminServiceException {
        Configurable[] sis = this.configurator.getTopEntries(SERVICE_INSTANCE);
        ServiceInstanceInfo[] toRet = new ServiceInstanceInfo[sis.length];
        int realCnt = 0;
        DescriptorConverter.NameHolder holder = new DescriptorConverter.NameHolder();
        int i = 0;
        while (i < sis.length) {
            ServiceInstanceConfig sc = (ServiceInstanceConfig)sis[i].narrow(class$com$idoox$wasp$server$config$ServiceInstanceConfig == null ? ConfigServiceAdministration.class$("com.idoox.wasp.server.config.ServiceInstanceConfig") : class$com$idoox$wasp$server$config$ServiceInstanceConfig);
            if (sc != null) {
                ServiceInstanceInfo sii;
                DescriptorConverter.decodeName((String)sc.getName(), (DescriptorConverter.NameHolder)holder);
                toRet[realCnt] = sii = new ServiceInstanceInfo(new ServiceInstance(holder.context, holder.targetNamespace, holder.name), 0, 0);
                ++realCnt;
            }
            ++i;
        }
        if (realCnt != toRet.length) {
            ServiceInstanceInfo[] newToRet = new ServiceInstanceInfo[realCnt];
            System.arraycopy(toRet, 0, newToRet, 0, realCnt);
            toRet = newToRet;
        }
        return toRet;
    }

    public ServiceInstanceInfo getServiceInstance(ServiceInstance serviceInstance) throws AdminServiceException {
        if (serviceInstance == null) {
            throw new AdminServiceException("Service instance descriptor can't be null!");
        }
        if (serviceInstance.name == null) {
            throw new AdminServiceException("Service instance name can't be null!");
        }
        ServiceInstanceConfig sc = (ServiceInstanceConfig)this.configurator.getConfigurable(SERVICE_INSTANCE, ConfigServiceAdministration.encodeServiceInstance(serviceInstance));
        if (sc == null) {
            return null;
        }
        return new ServiceInstanceInfo(serviceInstance, 0, 0);
    }

    public int serviceInstanceStateControl(ServiceInstance serviceInstance, int controlOperation) throws AdminServiceException {
        throw new AdminServiceException("serviceInstanceStateControl method is unsupported");
    }

    public void enableServiceInstance(ServiceInstance serviceInstance) throws AdminServiceException {
        if (serviceInstance == null) {
            throw new AdminServiceException("Service instance descriptor can't be null!");
        }
        if (serviceInstance.name == null) {
            throw new AdminServiceException("Service instance name can't be null!");
        }
        ServiceInstanceConfig sc = (ServiceInstanceConfig)this.configurator.getConfigurable(SERVICE_INSTANCE, ConfigServiceAdministration.encodeServiceInstance(serviceInstance));
        if (sc == null) {
            return;
        }
        sc.setDisabled(false);
    }

    public void disableServiceInstance(ServiceInstance serviceInstance) throws AdminServiceException {
        if (serviceInstance == null) {
            throw new AdminServiceException("Service instance descriptor can't be null!");
        }
        if (serviceInstance.name == null) {
            throw new AdminServiceException("Service instance name can't be null!");
        }
        ServiceInstanceConfig sc = (ServiceInstanceConfig)this.configurator.getConfigurable(SERVICE_INSTANCE, ConfigServiceAdministration.encodeServiceInstance(serviceInstance));
        if (sc == null) {
            return;
        }
        sc.setDisabled(true);
    }

    public void startServiceInstance(ServiceInstance serviceInstance) throws AdminServiceException {
        throw new AdminServiceException("startServiceInstance method is unsupported");
    }

    public void stopServiceInstance(ServiceInstance serviceInstance) throws AdminServiceException {
        throw new AdminServiceException("stopServiceInstance method is unsupported");
    }

    public ServiceEndpointInfo[] getServiceInstanceEndpoints(ServiceInstance serviceInstance) throws AdminServiceException {
        if (serviceInstance == null) {
            throw new AdminServiceException("Service instance descriptor can't be null!");
        }
        if (serviceInstance.name == null) {
            throw new AdminServiceException("Service instance name can't be null!");
        }
        ServiceEndpointInfo[] toRet = new ServiceEndpointInfo[2];
        Configurable[] ses = this.configurator.getTopEntries(POST_SERVICE_ENDPOINT);
        int realCnt = 0;
        String encodedName = ConfigServiceAdministration.encodeServiceInstance(serviceInstance);
        int i = 0;
        while (i < ses.length) {
            ServiceBindingConfig sbc = (ServiceBindingConfig)ses[i].narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? ConfigServiceAdministration.class$("com.idoox.wasp.server.config.ServiceBindingConfig") : class$com$idoox$wasp$server$config$ServiceBindingConfig);
            if (sbc != null && sbc.getServiceClassRef().equals(encodedName)) {
                boolean debug;
                try {
                    debug = sbc.isDebug();
                }
                catch (Exception e) {
                    debug = false;
                }
                ServiceEndpointInfo sei = new ServiceEndpointInfo(new ServiceEndpoint(sbc.getName(), serviceInstance), debug);
                if (realCnt == toRet.length) {
                    ServiceEndpointInfo[] newToRet = new ServiceEndpointInfo[realCnt * 2];
                    System.arraycopy(toRet, 0, newToRet, 0, realCnt);
                    toRet = newToRet;
                }
                toRet[realCnt] = sei;
                ++realCnt;
            }
            ++i;
        }
        ses = this.configurator.getTopEntries(GET_SERVICE_ENDPOINT);
        int i2 = 0;
        while (i2 < ses.length) {
            ServiceBindingConfig sbc = (ServiceBindingConfig)ses[i2].narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? ConfigServiceAdministration.class$("com.idoox.wasp.server.config.ServiceBindingConfig") : class$com$idoox$wasp$server$config$ServiceBindingConfig);
            if (sbc != null && sbc.getServiceClassRef().equals(encodedName)) {
                boolean debug;
                try {
                    debug = sbc.isDebug();
                }
                catch (Exception e) {
                    debug = false;
                }
                ServiceEndpoint se = new ServiceEndpoint(sbc.getName(), serviceInstance);
                se.transportMethod = 4;
                ServiceEndpointInfo sei = new ServiceEndpointInfo(se, debug);
                if (realCnt == toRet.length) {
                    ServiceEndpointInfo[] newToRet = new ServiceEndpointInfo[realCnt * 2];
                    System.arraycopy(toRet, 0, newToRet, 0, realCnt);
                    toRet = newToRet;
                }
                toRet[realCnt] = sei;
                ++realCnt;
            }
            ++i2;
        }
        if (realCnt != toRet.length) {
            ServiceEndpointInfo[] newToRet = new ServiceEndpointInfo[realCnt];
            System.arraycopy(toRet, 0, newToRet, 0, realCnt);
            toRet = newToRet;
        }
        return toRet;
    }

    public ServiceEndpointInfo[] getServiceInstancesEndpoints(ServiceInstance[] serviceInstances) throws AdminServiceException {
        if (serviceInstances.length == 0) {
            return new ServiceEndpointInfo[0];
        }
        HashMap<String, ServiceInstance> matching = new HashMap<String, ServiceInstance>();
        int i = 0;
        while (i < serviceInstances.length) {
            if (serviceInstances[i] != null && serviceInstances[i].name != null) {
                matching.put(ConfigServiceAdministration.encodeServiceInstance(serviceInstances[i]), serviceInstances[i]);
            }
            ++i;
        }
        ServiceEndpointInfo[] toRet = new ServiceEndpointInfo[15];
        Configurable[] ses = this.configurator.getTopEntries(POST_SERVICE_ENDPOINT);
        int realCnt = 0;
        int i2 = 0;
        while (i2 < ses.length) {
            ServiceInstance serviceInstance;
            ServiceBindingConfig sbc = (ServiceBindingConfig)ses[i2].narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? ConfigServiceAdministration.class$("com.idoox.wasp.server.config.ServiceBindingConfig") : class$com$idoox$wasp$server$config$ServiceBindingConfig);
            if (sbc != null && (serviceInstance = (ServiceInstance)matching.get(sbc.getServiceClassRef())) != null) {
                boolean debug;
                try {
                    debug = sbc.isDebug();
                }
                catch (Exception e) {
                    debug = false;
                }
                ServiceEndpointInfo sei = new ServiceEndpointInfo(new ServiceEndpoint(sbc.getName(), serviceInstance), debug);
                if (realCnt == toRet.length) {
                    ServiceEndpointInfo[] newToRet = new ServiceEndpointInfo[realCnt * 2];
                    System.arraycopy(toRet, 0, newToRet, 0, realCnt);
                    toRet = newToRet;
                }
                toRet[realCnt] = sei;
                ++realCnt;
            }
            ++i2;
        }
        ses = this.configurator.getTopEntries(GET_SERVICE_ENDPOINT);
        int i3 = 0;
        while (i3 < ses.length) {
            ServiceInstance serviceInstance;
            ServiceBindingConfig sbc = (ServiceBindingConfig)ses[i3].narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? ConfigServiceAdministration.class$("com.idoox.wasp.server.config.ServiceBindingConfig") : class$com$idoox$wasp$server$config$ServiceBindingConfig);
            if (sbc != null && (serviceInstance = (ServiceInstance)matching.get(sbc.getServiceClassRef())) != null) {
                boolean debug;
                try {
                    debug = sbc.isDebug();
                }
                catch (Exception e) {
                    debug = false;
                }
                ServiceEndpoint se = new ServiceEndpoint(sbc.getName(), serviceInstance);
                se.transportMethod = 4;
                ServiceEndpointInfo sei = new ServiceEndpointInfo(se, debug);
                if (realCnt == toRet.length) {
                    ServiceEndpointInfo[] newToRet = new ServiceEndpointInfo[realCnt * 2];
                    System.arraycopy(toRet, 0, newToRet, 0, realCnt);
                    toRet = newToRet;
                }
                toRet[realCnt] = sei;
                ++realCnt;
            }
            ++i3;
        }
        if (realCnt != toRet.length) {
            ServiceEndpointInfo[] newToRet = new ServiceEndpointInfo[realCnt];
            System.arraycopy(toRet, 0, newToRet, 0, realCnt);
            toRet = newToRet;
        }
        return toRet;
    }

    public ServiceEndpointInfo getServiceEndpoint(ServiceEndpoint serviceEndpoint) throws AdminServiceException {
        boolean debug;
        if (serviceEndpoint == null) {
            throw new AdminServiceException("Provided service endpoint descriptor is null.");
        }
        if (serviceEndpoint.path == null) {
            throw new AdminServiceException("Service endpoint path can't be null!");
        }
        ServiceBindingConfig sbc = null;
        switch (serviceEndpoint.transportMethod) {
            case 4: {
                sbc = (ServiceBindingConfig)this.configurator.getConfigurable(GET_SERVICE_ENDPOINT, serviceEndpoint.path);
                break;
            }
            default: {
                sbc = (ServiceBindingConfig)this.configurator.getConfigurable(POST_SERVICE_ENDPOINT, serviceEndpoint.path);
            }
        }
        if (sbc == null) {
            throw new AdminServiceException("Configuration of " + serviceEndpoint.path + " not found");
        }
        try {
            debug = sbc.isDebug();
        }
        catch (Exception e) {
            debug = false;
        }
        ServiceEndpointInfo sei = new ServiceEndpointInfo(serviceEndpoint, debug);
        return sei;
    }

    public InterceptorInfo[] interceptorControl(ServiceEndpoint serviceEndpoint, int controlOperation, InterceptorInfo interceptorInfo) throws AdminServiceException {
        throw new AdminServiceException("interceptorControl method is unsupported");
    }

    public int messageSizeInterceptorControl(ServiceEndpoint serviceEndpoint, int controlOperation, int maxMessageLength) throws AdminServiceException {
        throw new AdminServiceException("messageSizeInterceptorControl method is unsupported");
    }

    public IpFilterInfo ipFilterInterceptorControl(ServiceEndpoint serviceEndpoint, int controlOperation, boolean allowedByDefault, IpFilterRule[] ipFilterRules) throws AdminServiceException {
        throw new AdminServiceException("ipFilterInterceptorControl method is unsupported");
    }

    public Package getPackage(ServiceInstance serviceInstance) throws AdminServiceException {
        throw new AdminServiceException("getPackage method is unsupported");
    }

    public boolean polymorphismControl(ServiceEndpoint serviceEndpoint, int controlOperation) throws AdminServiceException {
        if (serviceEndpoint == null) {
            throw new AdminServiceException("Service endpoint can't be null!");
        }
        if (serviceEndpoint.path == null) {
            throw new AdminServiceException("Service endpoint path can't be null!");
        }
        ServiceBindingConfig sbc = null;
        switch (serviceEndpoint.transportMethod) {
            case 4: {
                sbc = (ServiceBindingConfig)this.configurator.getConfigurable(GET_SERVICE_ENDPOINT, serviceEndpoint.path);
                break;
            }
            default: {
                sbc = (ServiceBindingConfig)this.configurator.getConfigurable(POST_SERVICE_ENDPOINT, serviceEndpoint.path);
            }
        }
        if (sbc == null) {
            throw new AdminServiceException("Configuration of " + serviceEndpoint.path + " not found");
        }
        switch (controlOperation) {
            case 32: {
                break;
            }
            case 2: {
                sbc.setPolymorphismEnabled(true);
                break;
            }
            case 4: {
                sbc.setPolymorphismEnabled(false);
                break;
            }
            default: {
                throw new AdminServiceException("Unsupported control operation");
            }
        }
        Boolean retVal = sbc.isPolymorphismEnabled();
        if (retVal == null) {
            return false;
        }
        return retVal;
    }

    public String[] getEndpointOperations(String endpointPath) throws AdminServiceException {
        throw new AdminServiceException("getEndpointOperations method is unsupported");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

