/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.systinet.persistence.PersistenceDbCoreException;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.PersistenceManager;
import com.systinet.persistence.PersistenceSqlException;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.PersistentFieldFilter;
import com.systinet.uddi.database.ConnectionMonitor;
import com.systinet.uddi.database.DatabaseCoreException;
import com.systinet.uddi.database.TransactionManager;
import com.systinet.wasp.persistentstore.DbTerminatorHelper;
import com.systinet.wasp.persistentstore.PersistentStorePersistenceException;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import org.systinet.wasp.transaction.db.DbTerminator;

public abstract class DbPersistentStore {
    protected static final PersistenceManager persMgr = PersistenceManager.getInstance();
    protected final int waspInstance;

    DbPersistentStore(int waspInstance) {
        this.waspInstance = waspInstance;
    }

    final void insertCommon(Object obj) throws PersistentStorePersistenceException {
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                persMgr.insert(obj);
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final int updateCommon(Object obj, PersistentFieldFilter updateSpec) throws PersistentStorePersistenceException {
        int n;
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            try {
                n = persMgr.update(obj, updateSpec);
                Object var6_6 = null;
            }
            catch (PersistenceException e) {
                throw new PersistentStorePersistenceException(e);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
        return n;
    }

    final int updateSqlCommon(String pstmtSql, Constant[] parameters) throws PersistentStorePersistenceException {
        int n;
        DbTerminator terminator = DbTerminatorHelper.ensureTx();
        try {
            n = DbPersistentStore.updateSqlCommonStatic(pstmtSql, parameters);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            DbTerminator.suspendTx((DbTerminator)terminator);
            throw throwable;
        }
        DbTerminator.suspendTx((DbTerminator)terminator);
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final int updateSqlCommonStatic(String pstmtSql, Constant[] parameters) throws PersistentStorePersistenceException {
        try {
            int n;
            TransactionManager txMgr = persMgr.getDatabase().getTransactionManager();
            txMgr.beginReadWrite();
            boolean ok = false;
            try {
                int rowCount;
                block12: {
                    ConnectionMonitor conn = txMgr.getConnection();
                    PreparedStatement pstmt = null;
                    try {
                        pstmt = conn.prepareStatement(pstmtSql);
                        if (parameters != null) {
                            int i = 0;
                            while (i < parameters.length) {
                                parameters[i].setPrepStmtParam(pstmt, i + 1);
                                ++i;
                            }
                        }
                        rowCount = pstmt.executeUpdate();
                        Object var9_11 = null;
                        if (pstmt == null) break block12;
                    }
                    catch (Throwable throwable) {
                        Object var9_12 = null;
                        if (pstmt != null) {
                            conn.close((Statement)pstmt);
                        }
                        throw throwable;
                    }
                    conn.close((Statement)pstmt);
                }
                txMgr.commit();
                ok = true;
                n = rowCount;
                Object var11_14 = null;
                if (ok) return n;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                if (!ok) {
                    txMgr.rollback();
                }
                throw throwable;
            }
            txMgr.rollback();
            return n;
        }
        catch (SQLException e) {
            throw new PersistentStorePersistenceException((Throwable)new PersistenceSqlException(e));
        }
        catch (DatabaseCoreException e) {
            throw new PersistentStorePersistenceException(new PersistenceDbCoreException(e));
        }
        catch (PersistenceException e) {
            throw new PersistentStorePersistenceException(e);
        }
    }
}

