/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.persistentstore;

import com.idoox.debug.Category;
import com.systinet.persistence.PersistenceException;
import com.systinet.persistence.ResultSetIterator;
import com.systinet.persistence.query.Constant;
import com.systinet.persistence.query.Expression;
import com.systinet.persistence.query.PersistentClass;
import com.systinet.persistence.query.PersistentField;
import com.systinet.persistence.query.Query;
import com.systinet.wasp.persistentstore.DbPersistentStore;
import com.systinet.wasp.persistentstore.DbPersistentStoreManagement;
import com.systinet.wasp.persistentstore.DbSequenceData;
import com.systinet.wasp.persistentstore.DbSequencePersistentStore;
import com.systinet.wasp.persistentstore.DbSequenceQueue;
import com.systinet.wasp.persistentstore.PersistentStorePersistenceException;
import com.systinet.wasp.persistentstore.WaspInstanceHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.idoox.util.RuntimeWrappedException;
import org.systinet.wasp.sequence.PersistentStoreException;
import org.systinet.wasp.sequence.management.PersistentSequenceStoreManagement;

public class DbSequenceStoreManagement
extends DbPersistentStoreManagement
implements PersistentSequenceStoreManagement {
    private static Category log = Category.getCategory((String)"com.systinet.wasp.persistentstore.DbSequenceStoreManagement");
    private volatile boolean initialized = false;
    static /* synthetic */ Class class$com$systinet$wasp$persistentstore$DbSequenceData;

    private synchronized void ensureInit() {
        if (this.initialized) {
            return;
        }
        try {
            DbSequencePersistentStore.ensureTablesExist();
        }
        catch (PersistentStoreException e) {
            throw new RuntimeWrappedException("Initization failed", (Throwable)e);
        }
        this.initialized = true;
    }

    public void clear() {
        this.ensureInit();
        DbPersistentStoreManagement.clearTables(new PersistentClass[]{DbSequenceData.PERS_CLASS, DbSequenceQueue.PERS_CLASS});
    }

    public Iterator select() {
        this.ensureInit();
        try {
            Iterator iterator;
            Expression waspInstanceCond = DbSequenceData.WASP_INSTANCE_FIELD.equal((long)WaspInstanceHelper.getWaspInstance());
            Query getSeqQ = new Query(waspInstanceCond);
            try {
                ArrayList<DbSequenceData> results = new ArrayList<DbSequenceData>();
                ResultSetIterator i = getSeqQ.execute();
                while (i.hasNext()) {
                    DbSequenceData cc = (DbSequenceData)i.next();
                    results.add(cc);
                }
                iterator = results.iterator();
                Object var7_7 = null;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                getSeqQ.close();
                throw throwable;
            }
            getSeqQ.close();
            return iterator;
        }
        catch (PersistenceException e) {
            log.warn("Select failed", (Throwable)e);
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public Collection selectAll(String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        if (waspInstance == null) {
            return this.createResultListFromQuery(new Query(class$com$systinet$wasp$persistentstore$DbSequenceData == null ? (class$com$systinet$wasp$persistentstore$DbSequenceData = DbSequenceStoreManagement.class$("com.systinet.wasp.persistentstore.DbSequenceData")) : class$com$systinet$wasp$persistentstore$DbSequenceData));
        }
        int waspId = WaspInstanceHelper.translateWaspInstance(waspInstance);
        if (waspId == -1) {
            return new ArrayList(1);
        }
        Expression where = DbSequenceData.WASP_INSTANCE_FIELD.equal((long)waspId);
        return this.createResultListFromQuery(new Query(where));
    }

    public Collection selectByEndpoint(String endpoint, String sequencePrefix, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        int waspId = -1;
        if (waspInstance != null && (waspId = WaspInstanceHelper.translateWaspInstance(waspInstance)) == -1) {
            return new ArrayList(1);
        }
        Expression where = this.createWhereByEndpoint(endpoint, sequencePrefix, waspId);
        return this.createResultListFromWhere(where);
    }

    public Collection selectById(String id, PersistentSequenceStoreManagement.SequenceDirection direction, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        int waspId = -1;
        if (waspInstance != null && (waspId = WaspInstanceHelper.translateWaspInstance(waspInstance)) == -1) {
            return new ArrayList(1);
        }
        Expression where = this.createWhereById(id, direction, waspId);
        return this.createResultListFromWhere(where);
    }

    public Collection selectByPrefix(String prefix, PersistentSequenceStoreManagement.SequenceDirection direction, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        int waspId = -1;
        if (waspInstance != null && (waspId = WaspInstanceHelper.translateWaspInstance(waspInstance)) == -1) {
            return new ArrayList(1);
        }
        Expression where = this.createWhereByPrefix(prefix, direction, waspId);
        return this.createResultListFromWhere(where);
    }

    public int deleteAll(String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        if (waspInstance == null) {
            DbPersistentStoreManagement.updateSqlCommon("DELETE FROM " + DbSequenceQueue.PERS_CLASS.getName(), (Constant[])null);
            return DbPersistentStoreManagement.updateSqlCommon("DELETE FROM " + DbSequenceData.PERS_CLASS.getName(), (Constant[])null);
        }
        int waspId = WaspInstanceHelper.translateWaspInstance(waspInstance);
        if (waspId == -1) {
            return 0;
        }
        Expression queueWhere = DbSequenceQueue.WASP_INSTANCE_FIELD.equal((long)waspId);
        this.deleteForWhere(queueWhere);
        Expression where = DbSequenceData.WASP_INSTANCE_FIELD.equal((long)waspId);
        return this.deleteForWhere(where);
    }

    public int deleteByEndpoint(String endpoint, String sequencePrefix, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        int waspId = -1;
        if (waspInstance != null && (waspId = WaspInstanceHelper.translateWaspInstance(waspInstance)) == -1) {
            return 0;
        }
        this.deleteFromQueuesByEndpoint(endpoint, sequencePrefix, waspId);
        Expression whereCond = this.createWhereByEndpoint(endpoint, sequencePrefix, waspId);
        return this.deleteForWhere(whereCond);
    }

    public int deleteById(String id, PersistentSequenceStoreManagement.SequenceDirection direction, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        int waspId = -1;
        if (waspInstance != null && (waspId = WaspInstanceHelper.translateWaspInstance(waspInstance)) == -1) {
            return 0;
        }
        this.deteleFromQueuesById(id, direction, waspId);
        Expression whereCond = this.createWhereById(id, direction, waspId);
        return this.deleteForWhere(whereCond);
    }

    public int deleteByPrefix(String prefix, PersistentSequenceStoreManagement.SequenceDirection direction, String waspInstance) throws PersistentStoreException {
        this.ensureInit();
        int waspId = -1;
        if (waspInstance != null && (waspId = WaspInstanceHelper.translateWaspInstance(waspInstance)) == -1) {
            return 0;
        }
        this.deteleFromQueuesByPrefix(prefix, direction, waspId);
        Expression whereCond = this.createWhereByPrefix(prefix, direction, waspId);
        return this.deleteForWhere(whereCond);
    }

    private Expression createWhereByEndpoint(String endpoint, String sequencePrefix, int waspId) {
        Expression whereCond = DbSequenceData.ENDPOINT_PATH_FIELD.equal(endpoint);
        if (sequencePrefix != null) {
            whereCond = whereCond.and(DbSequenceData.ID_FIELD.like(this.createPrefixForLike(sequencePrefix)));
        }
        if (waspId != -1) {
            whereCond = whereCond.and(DbSequenceData.WASP_INSTANCE_FIELD.equal((long)waspId));
        }
        return whereCond;
    }

    private void deleteFromQueuesByEndpoint(String endpoint, String sequencePrefix, int waspId) throws PersistentStorePersistenceException {
        StringBuffer sql = new StringBuffer();
        ArrayList<Constant> params = new ArrayList<Constant>(4);
        sql.append("DELETE FROM " + DbSequenceQueue.PERS_CLASS.getName() + " WHERE ");
        if (waspId != -1) {
            sql.append(DbSequenceQueue.WASP_INSTANCE_FIELD.name() + "=? AND ");
            params.add(Constant.valueOf((int)waspId));
        }
        if (sequencePrefix != null) {
            sql.append(DbSequenceQueue.ID_PERS_FIELD.name() + " LIKE ? AND ");
            params.add(Constant.valueOf((String)this.createPrefixForLike(sequencePrefix)));
        }
        sql.append("1 IN (SELECT 1 ");
        sql.append(" FROM " + DbSequenceData.PERS_CLASS.getName());
        sql.append(" WHERE " + DbSequenceData.ENDPOINT_PATH_FIELD.name() + "=?");
        params.add(Constant.valueOf((String)endpoint));
        sql.append(" AND DbSequenceQueue.waspInstancePK=DbSequenceData.waspInstancePK");
        sql.append(" AND DbSequenceQueue.idPK=DbSequenceData.idPK");
        sql.append(" AND DbSequenceQueue.outputPK=DbSequenceData.outputPK");
        sql.append(")");
        DbPersistentStore.updateSqlCommonStatic(sql.toString(), params.toArray(new Constant[params.size()]));
    }

    private Expression createWhereById(String id, PersistentSequenceStoreManagement.SequenceDirection direction, int waspId) {
        Expression where = DbSequenceData.ID_FIELD.equal(id);
        where = this.addDirectionAndWaspIdToWhere(where, direction, waspId);
        return where;
    }

    private void deteleFromQueuesById(String id, PersistentSequenceStoreManagement.SequenceDirection direction, int waspId) throws PersistentStoreException {
        Expression where = DbSequenceQueue.ID_PERS_FIELD.equal(id);
        where = this.addDirectionAndWaspIdToQueueWhere(where, direction, waspId);
        this.deleteForWhere(where);
    }

    private Expression createWhereByPrefix(String prefix, PersistentSequenceStoreManagement.SequenceDirection direction, int waspId) {
        Expression where = DbSequenceData.ID_FIELD.like(this.createPrefixForLike(prefix));
        where = this.addDirectionAndWaspIdToWhere(where, direction, waspId);
        return where;
    }

    private void deteleFromQueuesByPrefix(String prefix, PersistentSequenceStoreManagement.SequenceDirection direction, int waspId) throws PersistentStoreException {
        Expression where = DbSequenceQueue.ID_PERS_FIELD.like(this.createPrefixForLike(prefix));
        where = this.addDirectionAndWaspIdToQueueWhere(where, direction, waspId);
        this.deleteForWhere(where);
    }

    private Expression addDirectionAndWaspIdToWhere(Expression where, PersistentSequenceStoreManagement.SequenceDirection direction, int waspId) {
        return this.addDirectionAndWaspIdToQueueCommon(where, direction, waspId, DbSequenceData.OUTPUT_FIELD, DbSequenceData.WASP_INSTANCE_FIELD);
    }

    private Expression addDirectionAndWaspIdToQueueWhere(Expression where, PersistentSequenceStoreManagement.SequenceDirection direction, int waspId) {
        return this.addDirectionAndWaspIdToQueueCommon(where, direction, waspId, DbSequenceQueue.OUTPUT_PERS_FIELD, DbSequenceQueue.WASP_INSTANCE_FIELD);
    }

    private Expression addDirectionAndWaspIdToQueueCommon(Expression where, PersistentSequenceStoreManagement.SequenceDirection direction, int waspId, PersistentField outputField, PersistentField waspInstanceField) {
        if (direction != PersistentSequenceStoreManagement.SequenceDirection.ANY) {
            where = where.and(outputField.equal(direction != PersistentSequenceStoreManagement.SequenceDirection.INPUT));
        }
        if (waspId != -1) {
            where = where.and(waspInstanceField.equal((long)waspId));
        }
        return where;
    }

    private List createResultListFromWhere(Expression where) throws PersistentStoreException {
        Query q = new Query(where);
        return this.createResultListFromQuery(q);
    }

    private List createResultListFromQuery(Query q) throws PersistentStoreException {
        try {
            ArrayList<Object> arrayList;
            try {
                ArrayList<Object> result = new ArrayList<Object>();
                ResultSetIterator i = q.execute();
                while (i.hasNext()) {
                    result.add(i.next());
                }
                arrayList = result;
                Object var6_6 = null;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                q.close();
                throw throwable;
            }
            q.close();
            return arrayList;
        }
        catch (PersistenceException e) {
            throw new PersistentStorePersistenceException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

