/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.debug;

import com.idoox.debug.Category;
import com.idoox.debug.ICategory;
import java.util.Map;

class CategoryFake
implements ICategory {
    private String name;
    private int level;

    private CategoryFake(String name, Integer level) {
        this.name = name;
        this.level = level != null ? level : 2;
    }

    private CategoryFake(String name) {
        this.name = name;
        this.level = Category.getDebugLevel() != null ? Category.getDebugLevel() : 2;
    }

    public static void initialize(Map props) {
    }

    public static ICategory getCategory(String name, Integer level) {
        return new CategoryFake(name, level);
    }

    public static ICategory getCategory(String name) {
        return new CategoryFake(name);
    }

    public void assertLog(boolean assertion, String msg) {
        if (!assertion) {
            this.error(msg);
        }
    }

    public void debug(Object message) {
        this.debug(message.toString());
    }

    public void debug(String message) {
        if (this.level >= 4) {
            System.err.println("DEBUG: " + this.name + " - " + message);
        }
    }

    public void debug(String message, Throwable t) {
        if (this.level >= 4) {
            this.debug(message);
            this.printThrowable(t);
        }
    }

    public void error(Object message) {
        this.error(message.toString());
    }

    public void error(String message) {
        if (this.level >= 1) {
            System.err.println("ERROR: " + this.name + " - " + message);
        }
    }

    public void error(String message, Throwable t) {
        if (this.level >= 1) {
            this.error(message);
            this.printThrowable(t);
        }
    }

    public final String getName() {
        return this.name;
    }

    public void info(Object message) {
        this.info(message.toString());
    }

    public void info(String message) {
        if (this.level >= 3) {
            System.err.println("INFO: " + this.name + " - " + message);
        }
    }

    public void info(String message, Throwable t) {
        if (this.level >= 3) {
            this.info(message);
            this.printThrowable(t);
        }
    }

    public boolean isDebugEnabled() {
        return this.level >= 4;
    }

    public boolean isInfoEnabled() {
        return this.level >= 3;
    }

    public void warn(Object message) {
        this.warn(message.toString());
    }

    public void warn(String message) {
        if (this.level >= 2) {
            System.err.println("WARNING: " + this.name + " - " + message);
        }
    }

    public void warn(String message, Throwable t) {
        if (this.level >= 2) {
            this.warn(message);
            this.printThrowable(t);
        }
    }

    private void printThrowable(Throwable t) {
        System.err.print(" EXCEPTION: ");
        if (t != null) {
            String m = t.getMessage();
            if (m == null) {
                System.err.println("no message");
            } else {
                System.err.println(m);
            }
            t.printStackTrace();
        } else {
            System.err.println("Cannot print throwable: t is null");
        }
    }

    public int getDebugLevel() {
        return this.level;
    }

    public void setDebugLevel(int level) {
        this.level = level;
    }
}

