/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.debug;

import com.idoox.debug.Category;

public class IndentCategory {
    Category impl;
    private String space = "";

    public IndentCategory(Category impl) {
        this.impl = impl;
    }

    public void debug(String message) {
        this.impl.debug(this.space + message);
    }

    public void debug(String message, Throwable t) {
        this.impl.debug(this.space + message, t);
    }

    public void error(String message) {
        this.impl.error(this.space + message);
    }

    public void error(String message, Throwable t) {
        this.impl.error(this.space + message, t);
    }

    public void info(String message) {
        this.impl.info(this.space + message);
    }

    public void info(String message, Throwable t) {
        this.impl.info(this.space + message, t);
    }

    public void warn(String message) {
        this.impl.warn(this.space + message);
    }

    public void warn(String message, Throwable t) {
        this.impl.warn(this.space + message, t);
    }

    public void enter(String msg) {
        if (this.impl.isDebugEnabled()) {
            IndentCategory indentCategory = this;
            synchronized (indentCategory) {
                this.debug(msg + " {");
                this.space = this.space + "  ";
            }
        }
    }

    public void enterInfo(String msg) {
        if (this.impl.isDebugEnabled()) {
            IndentCategory indentCategory = this;
            synchronized (indentCategory) {
                this.info(msg + " {");
                this.space = this.space + "  ";
            }
        }
    }

    public void leave() {
        if (this.impl.isDebugEnabled()) {
            IndentCategory indentCategory = this;
            synchronized (indentCategory) {
                try {
                    this.space = this.space.substring(2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.debug("}");
            }
        }
    }

    public void leaveInfo() {
        if (this.impl.isDebugEnabled()) {
            IndentCategory indentCategory = this;
            synchronized (indentCategory) {
                try {
                    this.space = this.space.substring(2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.info("}");
            }
        }
    }

    public boolean isDebugEnabled() {
        return this.impl.isDebugEnabled();
    }
}

