/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security;

import com.idoox.debug.Category;
import java.security.Principal;
import java.util.Iterator;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.idoox.security.AssociationOptions;
import org.idoox.security.Credentials;
import org.idoox.security.util.RuntimeWrappedException;

public class CredentialsImpl
implements Credentials {
    private static Category log = Category.getCategory((class$com$idoox$security$CredentialsImpl == null ? (class$com$idoox$security$CredentialsImpl = CredentialsImpl.class$("com.idoox.security.CredentialsImpl")) : class$com$idoox$security$CredentialsImpl).getName());
    protected AssociationOptions acceptingSupportedOptions;
    protected AssociationOptions acceptingRequiredOptions;
    protected AssociationOptions invocationSupportedOptions;
    protected AssociationOptions invocationRequiredOptions;
    protected int authenticationStatus;
    protected String providerName;
    protected Subject subject;
    protected String name;
    static /* synthetic */ Class class$com$idoox$security$CredentialsImpl;

    protected CredentialsImpl() {
        this.authenticationStatus = 2;
    }

    public CredentialsImpl(String name, String providerName, String loginContextName, CallbackHandler handler) {
        block3: {
            this.name = name;
            this.providerName = providerName;
            this.authenticationStatus = 2;
            try {
                LoginContext loginCtx = new LoginContext(loginContextName, handler);
                loginCtx.login();
                this.subject = loginCtx.getSubject();
                this.authenticationStatus = 0;
                if (name != null && name.length() != 0) break block3;
                Iterator<Principal> it = this.subject.getPrincipals().iterator();
                while (it.hasNext()) {
                    Principal princ = it.next();
                    if (!(princ instanceof Principal)) continue;
                    this.name = princ.getName();
                    break;
                }
            }
            catch (LoginException e) {
                log.debug("login fails", e);
                throw new RuntimeWrappedException("Login fails, root cause: " + e.getMessage(), e);
            }
        }
    }

    public int getAuthenticationStatus() {
        return this.authenticationStatus;
    }

    public String getProviderName() {
        return this.providerName;
    }

    public Subject getSubject() {
        return this.subject;
    }

    public AssociationOptions getAcceptingOptionsSupported() {
        return this.acceptingSupportedOptions;
    }

    public void setAcceptingOptionsSupported(AssociationOptions value) {
        this.acceptingSupportedOptions = value;
    }

    public AssociationOptions getAcceptingOptionsRequired() {
        return this.acceptingRequiredOptions;
    }

    public void setAcceptingOptionsRequired(AssociationOptions value) {
        this.acceptingRequiredOptions = value;
    }

    public AssociationOptions getInvocationOptionsSupported() {
        return this.invocationSupportedOptions;
    }

    public void setInvocationOptionsSupported(AssociationOptions value) {
        this.invocationSupportedOptions = value;
    }

    public AssociationOptions getInvocationOptionsRequired() {
        return this.invocationRequiredOptions;
    }

    public void setInvocationOptionsRequired(AssociationOptions value) {
        this.invocationRequiredOptions = value;
    }

    public boolean equals(Object another) {
        if (another instanceof CredentialsImpl) {
            CredentialsImpl other = (CredentialsImpl)another;
            if (this.acceptingRequiredOptions == other.acceptingRequiredOptions && this.acceptingSupportedOptions == other.acceptingSupportedOptions && this.invocationRequiredOptions == other.invocationRequiredOptions && this.invocationSupportedOptions == other.invocationSupportedOptions) {
                return this.subject.equals(other.subject);
            }
            return false;
        }
        return false;
    }

    public int hashCode() {
        return this.subject.hashCode();
    }

    public String toString() {
        return "Credentials for: " + this.name;
    }

    public String getName() {
        return this.name;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

