/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.asn1;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Explicit;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.asn1.SetOf;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class Constructed
extends Asn1 {
    protected ArrayList components;
    protected String typeName = "";

    public Constructed() {
        this.components = new ArrayList(3);
    }

    protected Constructed(ArrayList components) {
        this.components = components;
    }

    public static Asn1 decode(int tag, InputStream encoded, int[] length) throws Asn1Exception {
        byte cl = (byte)(tag & 0xFFFFFFC0);
        byte tagnum = (byte)(tag & 0x1F);
        if (cl == 0) {
            if (tagnum == 16) {
                return Sequence.decode(tag, encoded, length);
            }
            if (tagnum == 17) {
                return SetOf.decode(tag, encoded, length);
            }
            throw new Asn1Exception("Invalid tag number");
        }
        return Explicit.decode(tag, encoded, length);
    }

    public int doDecode(int tag, InputStream encoded) throws Asn1Exception {
        int[] lengthInt = new int[]{0};
        int length = Asn1.decodeLengthOctets(encoded, lengthInt);
        if (length == -1) {
            throw new Asn1Exception("Indefinite length encoding not yet supported");
        }
        length += lengthInt[0];
        while (lengthInt[0] < length) {
            this.components.add(Asn1.decode(encoded, lengthInt));
        }
        if (lengthInt[0] > length) {
            throw new Asn1Exception("Structure length overflow");
        }
        return length;
    }

    public void doEncode(OutputStream encoded) throws IOException {
        int i = 0;
        while (i < this.components.size()) {
            ((Asn1)this.components.get(i)).encode(encoded);
            ++i;
        }
    }

    public void doTag(OutputStream encoded) throws IOException {
        if (this.tagNum < 31) {
            encoded.write((byte)(this.classType | 0x20 | this.tagNum));
        } else {
            encoded.write((byte)(this.classType | 0x20 | 0x1F));
            encoded.write(this.encodeHighTag(this.tagNum));
        }
    }

    protected int getContentsLen() {
        int retval = 0;
        int i = 0;
        while (i < this.components.size()) {
            retval += ((Asn1)this.components.get(i)).getLength();
            ++i;
        }
        return retval;
    }

    public void addComponent(Asn1 value) {
        this.components.add(value);
    }

    public ArrayList getComponents() {
        return this.components;
    }
}

