/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.jaas;

import com.idoox.debug.Category;
import com.idoox.security.jaas.CallContextCallback;
import java.io.IOException;
import java.security.Principal;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.servlet.http.HttpServletRequest;
import weblogic.security.Security;
import weblogic.security.auth.callback.URLCallback;
import weblogic.security.principal.WLSUserImpl;
import weblogic.servlet.security.ServletAuthentication;

public class WlNamePasswordLoginModule
implements LoginModule {
    private static final Category log = Category.getCategory("com.idoox.security.jaas.WlNamePasswordLoginModule");
    private CallbackHandler callbackHandler;
    private boolean succeeded;
    private Subject jaasSubject;
    private HttpServletRequest servletRequest;
    public static final String SERVLET_REQUEST = "wasp.transport.servlet_request";
    static /* synthetic */ Class class$weblogic$security$principal$WLSUserImpl;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.jaasSubject = subject;
        String serverUrl = System.getProperty("weblogic.security.jaas.ServerURL");
        this.callbackHandler = new WlNamePasswordCallbackHandler(callbackHandler, serverUrl);
    }

    public boolean login() throws LoginException {
        Callback[] callbacks = new Callback[]{new CallContextCallback()};
        try {
            this.callbackHandler.handle(callbacks);
        }
        catch (IOException e) {
            log.error("", e);
            throw new LoginException(e.getMessage());
        }
        catch (UnsupportedCallbackException e) {
            log.error("", e);
            throw new LoginException(e.getMessage());
        }
        Map callContext = (Map)((CallContextCallback)callbacks[0]).getCallContext();
        this.servletRequest = (HttpServletRequest)callContext.get(SERVLET_REQUEST);
        if (ServletAuthentication.authenticate((CallbackHandler)this.callbackHandler, (HttpServletRequest)this.servletRequest) != 0) {
            throw new FailedLoginException("Unable to authenticate servlet request against BEA Weblogic security");
        }
        this.succeeded = true;
        return this.succeeded;
    }

    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        Subject currentSubject = Security.getCurrentSubject();
        Set wlsPrincipals = currentSubject.getPrincipals(class$weblogic$security$principal$WLSUserImpl == null ? (class$weblogic$security$principal$WLSUserImpl = WlNamePasswordLoginModule.class$("weblogic.security.principal.WLSUserImpl")) : class$weblogic$security$principal$WLSUserImpl);
        if (wlsPrincipals != null) {
            Iterator iterator = wlsPrincipals.iterator();
            while (iterator.hasNext()) {
                WLSUserImpl wlsUser = (WLSUserImpl)iterator.next();
                Set<Principal> principals = this.jaasSubject.getPrincipals();
                if (principals.contains(wlsUser)) continue;
                principals.add((Principal)wlsUser);
            }
        }
        return this.succeeded;
    }

    public boolean abort() throws LoginException {
        return ServletAuthentication.logout((HttpServletRequest)this.servletRequest);
    }

    public boolean logout() throws LoginException {
        return ServletAuthentication.logout((HttpServletRequest)this.servletRequest);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class WlNamePasswordCallbackHandler
    implements CallbackHandler {
        private CallbackHandler delegate;
        private String serverUrl;

        public WlNamePasswordCallbackHandler(CallbackHandler delegate, String serverUrl) {
            this.delegate = delegate;
            this.serverUrl = serverUrl;
        }

        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            Vector<Callback> delegateCallbacks = new Vector<Callback>(callbacks.length);
            int i = 0;
            while (i < callbacks.length) {
                Callback callback = callbacks[i];
                if (callback instanceof URLCallback) {
                    ((URLCallback)callback).setURL(this.serverUrl);
                } else {
                    delegateCallbacks.add(callback);
                }
                ++i;
            }
            this.delegate.handle(delegateCallbacks.toArray(new Callback[0]));
        }
    }
}

