/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.pkcs;

import com.idoox.debug.Category;
import com.idoox.security.util.PBERandomDerivation;
import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.util.HashMap;
import org.idoox.security.util.RuntimeWrappedException;

public class PKCS12RandomDerivation
implements PBERandomDerivation {
    private static Category dbg = Category.getCategory((class$com$idoox$security$pkcs$PKCS12RandomDerivation == null ? (class$com$idoox$security$pkcs$PKCS12RandomDerivation = PKCS12RandomDerivation.class$("com.idoox.security.pkcs.PKCS12RandomDerivation")) : class$com$idoox$security$pkcs$PKCS12RandomDerivation).getName());
    private static HashMap outputSizes = new HashMap();
    private static HashMap blockSizes = new HashMap();
    static /* synthetic */ Class class$com$idoox$security$pkcs$PKCS12RandomDerivation;

    public static byte[] generateRandom(int mode, byte[] password, byte[] salt, MessageDigest md, int ic, int size) {
        if (mode < 1 || mode > 3) {
            throw new IllegalArgumentException("Invalid generation mode");
        }
        if (md == null) {
            throw new IllegalArgumentException("Message Digest not specified");
        }
        int u = PKCS12RandomDerivation.getDigestOutputSize(md.getAlgorithm());
        int v = PKCS12RandomDerivation.getDigestBlockSize(md.getAlgorithm());
        byte[] D = new byte[v];
        int i = 0;
        while (i < v) {
            D[i] = (byte)mode;
            ++i;
        }
        ByteArrayOutputStream Istream = new ByteArrayOutputStream();
        try {
            int i2;
            if (salt != null && salt.length != 0) {
                int SLen = v * ((salt.length + v - 1) / v);
                i2 = 0;
                while (i2 + salt.length - 1 < SLen) {
                    Istream.write(salt);
                    i2 += salt.length;
                }
                Istream.write(salt, 0, SLen % salt.length);
            }
            if (password != null && password.length != 0) {
                int PLen = v * ((password.length + v - 1) / v);
                i2 = 0;
                while (i2 + password.length - 1 < PLen) {
                    Istream.write(password);
                    i2 += password.length;
                }
                Istream.write(password, 0, PLen % password.length);
            }
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
        byte[] I = Istream.toByteArray();
        int c = (size + u - 1) / u;
        byte[] A = new byte[c * u];
        int i3 = 0;
        while (i3 < c) {
            byte[] result;
            md.reset();
            md.update(D);
            md.update(I);
            int j = 0;
            while (j < ic) {
                result = md.digest();
                md.reset();
                md.update(result);
                ++j;
            }
            result = md.digest();
            System.arraycopy(result, 0, A, i3 * u, u);
            byte[] B = new byte[v];
            int j2 = 0;
            while (j2 + u - 1 < v) {
                System.arraycopy(result, 0, B, j2, u);
                j2 += u;
            }
            System.arraycopy(result, 0, B, u * (v / u), v % u);
            if (i3 < c - 1) {
                byte[] Ij_bytes = new byte[v];
                BigInteger B_int = new BigInteger(B);
                B_int = B_int.add(BigInteger.ONE);
                int j3 = 0;
                while (j3 < I.length) {
                    System.arraycopy(I, j3, Ij_bytes, 0, v);
                    BigInteger Ij = new BigInteger(Ij_bytes);
                    Ij = Ij.add(B_int);
                    byte[] res = Ij.toByteArray();
                    if (res.length < v) {
                        int delta = v - res.length;
                        int k = 0;
                        while (k < delta) {
                            I[j3 + k] = 0;
                            ++k;
                        }
                        System.arraycopy(res, 0, I, j3 + delta, res.length);
                    } else {
                        System.arraycopy(res, 0, I, j3, v);
                    }
                    j3 += v;
                }
            }
            ++i3;
        }
        byte[] retval = new byte[size];
        System.arraycopy(A, 0, retval, 0, size);
        return retval;
    }

    private static int getDigestOutputSize(String algName) {
        Integer retval = (Integer)outputSizes.get(algName);
        if (retval != null) {
            return retval;
        }
        return 0;
    }

    private static int getDigestBlockSize(String algName) {
        Integer retval = (Integer)blockSizes.get(algName);
        if (retval != null) {
            return retval;
        }
        return 0;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        outputSizes.put("SHA", new Integer(20));
        outputSizes.put("SHA1", new Integer(20));
        outputSizes.put("SHA-1", new Integer(20));
        outputSizes.put("MD5", new Integer(16));
        outputSizes.put("MD2", new Integer(16));
        outputSizes.put("RIPEMD160", new Integer(20));
        blockSizes.put("SHA", new Integer(64));
        blockSizes.put("SHA1", new Integer(64));
        blockSizes.put("SHA-1", new Integer(64));
        blockSizes.put("MD5", new Integer(64));
        blockSizes.put("MD2", new Integer(64));
        blockSizes.put("RIPEMD160", new Integer(64));
    }
}

