/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.rsa;

import java.math.BigInteger;

final class RSAAlgorithm {
    private static final BigInteger ONE = BigInteger.valueOf(1L);

    private RSAAlgorithm() {
    }

    public static BigInteger rsa(BigInteger X, BigInteger n, BigInteger exp, BigInteger p, BigInteger q, BigInteger u) {
        if (p == null) {
            return RSAAlgorithm.rsa(X, n, exp);
        }
        BigInteger primeExponentP = exp.mod(p.subtract(ONE));
        BigInteger primeExponentQ = exp.mod(q.subtract(ONE));
        return RSAAlgorithm.rsa(X, n, exp, p, q, primeExponentP, primeExponentQ, u);
    }

    public static BigInteger rsa(BigInteger X, BigInteger modulus, BigInteger exp, BigInteger primeP, BigInteger primeQ, BigInteger primeExponentP, BigInteger primeExponentQ, BigInteger crtCoefficient) {
        BigInteger q2;
        BigInteger p2;
        if (!crtCoefficient.equals(primeQ.modInverse(primeP))) {
            BigInteger t = primeQ;
            primeQ = primeP;
            primeP = t;
            t = primeExponentQ;
            primeExponentQ = primeExponentP;
            primeExponentP = t;
        }
        if ((p2 = X.mod(primeP).modPow(primeExponentP, primeP)).equals(q2 = X.mod(primeQ).modPow(primeExponentQ, primeQ))) {
            return q2;
        }
        BigInteger k = p2.subtract(q2).mod(primeP);
        BigInteger l = k.multiply(crtCoefficient).mod(primeP);
        return primeQ.multiply(l).add(q2);
    }

    public static BigInteger rsa(BigInteger X, BigInteger n, BigInteger exp) {
        return X.modPow(exp, n);
    }
}

