/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.debug.Category;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.idoox.security.SecurityConfig;
import org.idoox.security.SecurityConfigs;
import org.ietf.jgss.GSSManager;

public class GSSHelper {
    private static Map helpers = new HashMap();
    private static Category dbg = Category.getCategory("com.idoox.security.util.GSSHelper");

    public static GSSManager getManager1(String configId) {
        return GSSHelper.getInnerHelper(configId).getManager();
    }

    public static GSSManager getManager1(String configId, String mechName) throws NoSuchProviderException {
        return GSSHelper.getInnerHelper(configId).getManager(mechName);
    }

    private static InnerHelper getInnerHelper(String configId) {
        InnerHelper ret = (InnerHelper)helpers.get(configId);
        if (ret == null) {
            ret = new InnerHelper(configId);
        }
        helpers.put(configId, ret);
        return ret;
    }

    private static class InnerHelper {
        private boolean initialized = false;
        private GSSManager defaultManager;
        private Map managers = new HashMap(3);
        private String configId = "";

        InnerHelper(String configId) {
            this.configId = configId;
        }

        private synchronized void loadManagers() {
            if (this.initialized) {
                return;
            }
            SecurityConfig secConf = SecurityConfigs.getLocalSecurityConfig(this.configId);
            Iterator props = ((Hashtable)secConf.getProperties()).entrySet().iterator();
            while (props.hasNext()) {
                String managerName;
                Map.Entry entry = props.next();
                String key = (String)entry.getKey();
                if (key == null || !key.startsWith("gss.provider.") || "default".equals(managerName = key.substring(13))) continue;
                String className = (String)entry.getValue();
                try {
                    Object obj = secConf.getImplClassLoader().loadClass(className).newInstance();
                    if (!(obj instanceof GSSManager)) {
                        dbg.error("GSS-API provider " + managerName + " does not extend org.ietf.jgss.GSSManager class");
                        continue;
                    }
                    this.managers.put(managerName, obj);
                }
                catch (Exception e) {
                    dbg.error("Cannot load provider " + managerName + ": " + e.getMessage());
                }
            }
            String defaultName = SecurityConfigs.getSecurityConfig().getProperty("gss.provider.default");
            this.defaultManager = (GSSManager)this.managers.get(defaultName);
        }

        public GSSManager getManager() {
            if (!this.initialized) {
                this.loadManagers();
            }
            if (this.defaultManager == null) {
                throw new RuntimeException("Default GSS-API provider was not configured");
            }
            return this.defaultManager;
        }

        public GSSManager getManager(String mechName) throws NoSuchProviderException {
            GSSManager retval = (GSSManager)this.managers.get(mechName);
            if (retval == null) {
                throw new NoSuchProviderException("GSS-API provider " + mechName + " not found");
            }
            return retval;
        }
    }
}

