/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.util;

import com.idoox.debug.Category;
import com.idoox.security.pkcs.PKCS12RandomDerivation;
import com.idoox.security.util.Random;
import java.io.UnsupportedEncodingException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import org.idoox.security.util.RuntimeWrappedException;

public class PBEWithSHAAnd3_KeyTripleDES_CBC {
    private Category dbg = Category.getCategory((class$com$idoox$security$util$PBEWithSHAAnd3_KeyTripleDES_CBC == null ? (class$com$idoox$security$util$PBEWithSHAAnd3_KeyTripleDES_CBC = PBEWithSHAAnd3_KeyTripleDES_CBC.class$("com.idoox.security.util.PBEWithSHAAnd3_KeyTripleDES_CBC")) : class$com$idoox$security$util$PBEWithSHAAnd3_KeyTripleDES_CBC).getName());
    private SecretKeyFactory skf;
    private Cipher cipher;
    private MessageDigest md;
    static /* synthetic */ Class class$com$idoox$security$util$PBEWithSHAAnd3_KeyTripleDES_CBC;

    public PBEWithSHAAnd3_KeyTripleDES_CBC() {
        try {
            try {
                this.cipher = Cipher.getInstance("DESede/CBC/PKCS5Padding");
            }
            catch (NoSuchAlgorithmException e) {
                this.cipher = Cipher.getInstance("DESede");
            }
            this.skf = SecretKeyFactory.getInstance("DESede");
            this.md = MessageDigest.getInstance("SHA");
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
    }

    public Cipher init(int mode, String password, byte[] salt, int ic) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Invalid mode");
        }
        try {
            SecretKey key = this.getKey(password, salt, ic);
            IvParameterSpec ivSpec = this.getIvSpec(password, salt, ic);
            this.cipher.init(mode, (Key)key, ivSpec, Random.getRandom());
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        return this.cipher;
    }

    public SecretKey getKey(String password, byte[] salt, int ic) {
        SecretKey key;
        byte[] keyBytes = this.getDerivedBytes(1, password, salt, ic, 24);
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec(keyBytes);
            key = this.skf.generateSecret(keySpec);
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
        return key;
    }

    public IvParameterSpec getIvSpec(String password, byte[] salt, int ic) {
        byte[] ivBytes = this.getDerivedBytes(2, password, salt, ic, 8);
        return new IvParameterSpec(ivBytes);
    }

    public Cipher init(int mode, SecretKey key, IvParameterSpec ivSpec) {
        if (mode != 1 && mode != 2) {
            throw new IllegalArgumentException("Invalid mode");
        }
        try {
            this.cipher.init(mode, (Key)key, ivSpec, Random.getRandom());
        }
        catch (Exception e) {
            throw new RuntimeWrappedException(e);
        }
        return this.cipher;
    }

    private byte[] getDerivedBytes(int mode, String password, byte[] salt, int ic, int size) {
        int passSize = password.length() * 2 + 2;
        byte[] passwordBytes = new byte[passSize];
        try {
            System.arraycopy(password.getBytes("UTF-16BE"), 0, passwordBytes, 0, passSize - 2);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException(e);
        }
        passwordBytes[passSize - 2] = 0;
        passwordBytes[passSize - 1] = 0;
        return PKCS12RandomDerivation.generateRandom(mode, passwordBytes, salt, this.md, ic, size);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

