/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Explicit;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.x509.Asn1Cert;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;

public class CertificatePair
extends Sequence {
    private Certificate forward;
    private Certificate reverse;

    public CertificatePair(Certificate forward, Certificate reverse) {
        Explicit exp;
        this.forward = forward;
        this.reverse = reverse;
        if (forward != null) {
            exp = new Explicit(-128, 0);
            exp.addComponent(new Asn1Cert(forward));
            this.addComponent(exp);
        }
        if (reverse != null) {
            exp = new Explicit(-128, 1);
            exp.addComponent(new Asn1Cert(reverse));
            this.addComponent(exp);
        }
    }

    public CertificatePair(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public CertificatePair(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        int i = 0;
        this.doDecode(encoded);
        try {
            ByteArrayInputStream bi;
            CertificateFactory cf = CertificateFactory.getInstance("X509");
            Explicit exp = (Explicit)this.components.get(i);
            if (exp.getTagNumber() == 0) {
                bi = new ByteArrayInputStream(exp.getComponent().encode());
                this.forward = cf.generateCertificate(bi);
                ++i;
            }
            if (i == this.components.size()) {
                return;
            }
            exp = (Explicit)this.components.get(i);
            if (exp.getTagNumber() != 1) {
                throw new Asn1Exception("Invalid tag number");
            }
            bi = new ByteArrayInputStream(exp.getComponent().encode());
            this.reverse = cf.generateCertificate(bi);
        }
        catch (CertificateException e) {
            throw new Asn1Exception(e.getMessage());
        }
    }

    public Certificate getForward() {
        return this.forward;
    }

    public Certificate getReverse() {
        return this.reverse;
    }
}

