/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.x509.Extension;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Extensions
extends Sequence {
    private Map extns;

    public Extensions(Set extns) {
        this.extns = new HashMap(extns.size());
        Iterator it = extns.iterator();
        while (it.hasNext()) {
            Extension ext = (Extension)it.next();
            this.extns.put(ext.getOid(), ext);
            this.addComponent(ext);
        }
    }

    public Extensions(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public Extensions(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.extns = new HashMap(this.components.size());
        int i = 0;
        while (i < this.components.size()) {
            Extension ext = new Extension(((Asn1)this.components.get(i)).encode());
            this.extns.put(ext.getOid(), ext);
            ++i;
        }
    }

    public Set getCriticalOIDs() {
        HashSet<String> retval = new HashSet<String>();
        Set keys = this.extns.keySet();
        Iterator it = keys.iterator();
        while (it.hasNext()) {
            Extension ext = (Extension)this.extns.get(it.next());
            if (!ext.getCritical()) continue;
            retval.add(ext.getOid());
        }
        return retval;
    }

    public Set getOIDs() {
        return this.extns.keySet();
    }

    public byte[] getExtnValue(String oid) {
        return ((Extension)this.extns.get(oid)).getValue();
    }
}

