/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1;
import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.SetOf;
import com.idoox.security.x509.AVA;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;

public class RDN
extends SetOf
implements Comparable {
    private ArrayList elements = new ArrayList();
    private static HashMap orderedTypes = new HashMap();

    public RDN(String rdn) throws Asn1Exception {
        StringTokenizer tknz = new StringTokenizer(rdn, ";", false);
        StringBuffer sb = new StringBuffer(tknz.nextToken());
        while (tknz.hasMoreTokens()) {
            String avaStr = tknz.nextToken();
            if (avaStr.indexOf(61) == -1) {
                sb.append(";").append(avaStr);
                continue;
            }
            StringTokenizer avaTknz = new StringTokenizer(sb.toString(), "=", false);
            AVA ava = new AVA(avaTknz.nextToken().trim(), avaTknz.nextToken().trim());
            this.elements.add(ava);
            this.components.add(ava);
            sb = new StringBuffer(avaStr);
        }
        StringTokenizer avaTknz = new StringTokenizer(sb.toString(), "=", false);
        AVA ava = new AVA(avaTknz.nextToken().trim(), avaTknz.nextToken().trim());
        this.elements.add(ava);
        this.components.add(ava);
    }

    public RDN(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public RDN(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        int i = 0;
        while (i < this.components.size()) {
            this.elements.add(new AVA(((Asn1)this.components.get(i)).encode()));
            ++i;
        }
    }

    public String getName() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.elements.size()) {
            sb.append(((AVA)this.elements.get(i)).getName());
            if (i < this.elements.size() - 1) {
                sb.append(';');
            }
            ++i;
        }
        return sb.toString();
    }

    private String getTypeCode() {
        StringBuffer sb = new StringBuffer();
        Iterator it = ((AbstractList)this.elements).iterator();
        while (it.hasNext()) {
            sb.append((String)orderedTypes.get(((AVA)it.next()).getType()));
        }
        return sb.toString();
    }

    public int compareTo(Object o) {
        return this.getTypeCode().compareTo(((RDN)o).getTypeCode());
    }

    static {
        orderedTypes.put("C", "1");
        orderedTypes.put("ST", "2");
        orderedTypes.put("L", "3");
        orderedTypes.put("O", "4");
        orderedTypes.put("OU", "5");
        orderedTypes.put("CN", "6");
        orderedTypes.put("EmailAddress", "7");
    }
}

