/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.security.x509;

import com.idoox.security.asn1.Asn1Exception;
import com.idoox.security.asn1.Sequence;
import com.idoox.security.asn1.UTCTime;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class Validity
extends Sequence {
    private String notBefore;
    private String notAfter;

    public Validity(int days) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        StringBuffer now = new StringBuffer();
        now.append(String.valueOf(cal.get(1)).substring(2, 4));
        this.append(now, cal.get(2) + 1);
        this.append(now, cal.get(5));
        this.append(now, cal.get(11));
        this.append(now, cal.get(12));
        now.append("Z");
        this.notBefore = now.toString();
        this.addComponent(new UTCTime(this.notBefore));
        cal.add(5, days);
        now = new StringBuffer();
        now.append(String.valueOf(cal.get(1)).substring(2, 4));
        this.append(now, cal.get(2) + 1);
        this.append(now, cal.get(5));
        this.append(now, cal.get(11));
        this.append(now, cal.get(12));
        now.append("Z");
        this.notAfter = now.toString();
        this.addComponent(new UTCTime(this.notAfter));
    }

    public Validity(long seconds) {
        Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        StringBuffer now = new StringBuffer();
        now.append(String.valueOf(cal.get(1)).substring(2, 4));
        this.append(now, cal.get(2) + 1);
        this.append(now, cal.get(5));
        this.append(now, cal.get(11));
        this.append(now, cal.get(12));
        this.append(now, cal.get(13));
        now.append("Z");
        this.notBefore = now.toString();
        this.addComponent(new UTCTime(this.notBefore));
        cal.add(13, (int)seconds);
        now = new StringBuffer();
        now.append(String.valueOf(cal.get(1)).substring(2, 4));
        this.append(now, cal.get(2) + 1);
        this.append(now, cal.get(5));
        this.append(now, cal.get(11));
        this.append(now, cal.get(12));
        this.append(now, cal.get(13));
        now.append("Z");
        this.notAfter = now.toString();
        this.addComponent(new UTCTime(this.notAfter));
    }

    public Validity(String notBefore, String notAfter) {
        this.notBefore = notBefore;
        this.addComponent(new UTCTime(this.notBefore));
        this.notAfter = notAfter;
        this.addComponent(new UTCTime(this.notAfter));
    }

    public Validity(byte[] encoded) throws Asn1Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(encoded);
        this.init(bin);
    }

    public Validity(InputStream encoded) throws Asn1Exception {
        this.init(encoded);
    }

    private void init(InputStream encoded) throws Asn1Exception {
        this.doDecode(encoded);
        this.notBefore = ((UTCTime)this.components.get(0)).getTime();
        this.notAfter = ((UTCTime)this.components.get(1)).getTime();
    }

    public String toString() {
        return "Not Before: " + this.notBefore + "\n" + "Not After : " + this.notAfter;
    }

    public Date getNotBefore() {
        return ((UTCTime)this.components.get(0)).getDate();
    }

    public Date getNotAfter() {
        return ((UTCTime)this.components.get(1)).getDate();
    }

    private void append(StringBuffer sb, int number) {
        if (number < 10) {
            sb.append("0" + number);
        } else {
            sb.append(number);
        }
    }
}

