/*
 * Decompiled with CFR 0.152.
 */
package org.idoox.security.util;

import java.io.PrintStream;
import java.io.PrintWriter;

public class RuntimeWrappedException
extends RuntimeException {
    private Throwable reason;

    public RuntimeWrappedException() {
        this.reason = null;
    }

    public RuntimeWrappedException(String message) {
        super(message);
        this.reason = null;
    }

    public RuntimeWrappedException(String message, Throwable reason) {
        super(message);
        this.reason = reason;
    }

    public RuntimeWrappedException(Throwable reason) {
        super(reason.getMessage());
        this.reason = reason;
    }

    public void printStackTrace() {
        if (this.reason == null) {
            super.printStackTrace();
        } else {
            System.err.println(this.toString());
            this.reason.printStackTrace();
        }
    }

    public void printStackTrace(PrintStream p) {
        if (this.reason == null) {
            super.printStackTrace(p);
        } else {
            p.println(this.toString());
            this.reason.printStackTrace(p);
        }
    }

    public void printStackTrace(PrintWriter p) {
        if (this.reason == null) {
            super.printStackTrace(p);
        } else {
            p.println(this.toString());
            this.reason.printStackTrace(p);
        }
    }

    public Throwable getException() {
        return this.reason;
    }

    public Throwable getRootException() {
        if (this.reason instanceof RuntimeWrappedException) {
            return ((RuntimeWrappedException)this.reason).getRootException();
        }
        if (this.reason instanceof RuntimeWrappedException) {
            return ((RuntimeWrappedException)this.reason).getRootException();
        }
        return this.reason;
    }
}

