/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.interceptor;

import com.idoox.security.spkm.SpkmParseTokenResult;
import com.idoox.security.spkm.SpkmSupport;
import com.idoox.wasp.security.interceptor.InterceptorBase;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.idoox.security.ContextExpiredException;
import org.idoox.transport.InputMessage;
import org.idoox.transport.InputMessageWrapper;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class SecureInputMessage
extends InputMessageWrapper {
    private InputStream input;
    private GSSContext context;
    private String uri;
    private InterceptorBase interceptor;
    private byte[] plainBuf;
    private int bufPos;
    private boolean initialized;

    SecureInputMessage(InputMessage message, InputStream input, GSSContext context, InterceptorBase interceptor, String uri) {
        super(message);
        this.input = input;
        this.context = context;
        this.uri = uri;
        this.interceptor = interceptor;
    }

    public int read() throws IOException {
        if (!this.initialized) {
            this.initialize();
        }
        if (this.plainBuf.length == 0) {
            return -1;
        }
        if (this.bufPos < this.plainBuf.length) {
            return this.plainBuf[this.bufPos++] & 0xFF;
        }
        this.fillBuffer();
        if (this.plainBuf.length > 0) {
            return this.plainBuf[this.bufPos++] & 0xFF;
        }
        return -1;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    /*
     * Unable to fully structure code
     */
    public int read(byte[] b, int off, int len) throws IOException {
        block6: {
            block5: {
                if (!this.initialized) {
                    this.initialize();
                }
                if (this.plainBuf.length == 0) {
                    return -1;
                }
                readCount = 0;
                avail = this.plainBuf.length - this.bufPos;
                if (avail < len) break block5;
                System.arraycopy(this.plainBuf, this.bufPos, b, off, len);
                this.bufPos += len;
                readCount = len;
                break block6;
            }
            System.arraycopy(this.plainBuf, this.bufPos, b, off, avail);
            readCount = avail;
            off += avail;
            this.fillBuffer();
            if (this.plainBuf.length != 0) ** GOTO lbl31
            if (readCount > 0) {
                return readCount;
            }
            return -1;
lbl-1000:
            // 1 sources

            {
                if (len <= readCount + this.plainBuf.length) {
                    System.arraycopy(this.plainBuf, this.bufPos, b, off, len - readCount);
                    this.bufPos += len - readCount;
                    readCount = len;
                    continue;
                }
                System.arraycopy(this.plainBuf, this.bufPos, b, off, this.plainBuf.length);
                readCount += this.plainBuf.length;
                off += this.plainBuf.length;
                this.fillBuffer();
                if (this.plainBuf.length == 0) break;
lbl31:
                // 3 sources

                ** while (this.plainBuf.length > 0 && readCount < len)
            }
        }
        return readCount;
    }

    /*
     * Unable to fully structure code
     */
    public long skip(long n) throws IOException {
        block4: {
            if (!this.initialized) {
                this.initialize();
            }
            if (this.plainBuf.length == 0 || n < 1L) {
                return 0L;
            }
            skippedCount = 0L;
            avail = this.plainBuf.length - this.bufPos;
            if ((long)avail < n) ** GOTO lbl19
            this.bufPos = (int)((long)this.bufPos + n);
            skippedCount = n;
            break block4;
lbl-1000:
            // 1 sources

            {
                if ((long)avail >= n - skippedCount) {
                    this.bufPos = (int)((long)this.bufPos + (n - skippedCount));
                    skippedCount = n;
                    continue;
                }
                skippedCount += (long)avail;
                this.fillBuffer();
                if (this.plainBuf.length == 0) break;
                avail = this.plainBuf.length;
lbl19:
                // 3 sources

                ** while (this.plainBuf.length > 0 && skippedCount < n)
            }
        }
        return skippedCount;
    }

    public int available() throws IOException {
        if (!this.initialized) {
            this.initialize();
        }
        return this.plainBuf.length - this.bufPos;
    }

    public void mark(int readlimit) {
    }

    public void reset() throws IOException {
        throw new IOException("Marks are not supported");
    }

    public boolean markSupported() {
        return false;
    }

    private void initialize() throws IOException {
        if (this.context == null) {
            try {
                this.input.mark(200);
                SpkmParseTokenResult result = new SpkmParseTokenResult();
                SpkmSupport.spkmParseToken((InputStream)this.input, (SpkmParseTokenResult)result);
                this.input.reset();
                if (result.tokenType != 5) {
                    throw new IOException("Unexpected token type: " + SpkmSupport.tokenTypes[result.tokenType]);
                }
                this.context = result.context;
            }
            catch (GSSException e) {
                throw new IOException(e.toString());
            }
        }
        this.fillBuffer();
        this.initialized = true;
    }

    private void fillBuffer() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        MessageProp msgProp = new MessageProp(false);
        try {
            this.context.unwrap(this.input, bOut, msgProp);
        }
        catch (GSSException e) {
            if (this.input.read() == -1) {
                this.plainBuf = new byte[0];
                this.bufPos = 0;
                return;
            }
            throw new IOException(e.toString());
        }
        this.plainBuf = bOut.toByteArray();
        this.bufPos = 0;
    }

    public int getStatusCode() throws IOException {
        int retval = super.getStatusCode();
        if (retval == 408) {
            if (this.interceptor != null & this.uri != null) {
                this.interceptor.removeClientContext(this.uri);
            }
            throw new ContextExpiredException("Server returned error code: 408");
        }
        return retval;
    }

    public String getContentType() throws IOException {
        String origContentType = this.getStringHeader("x-idoox-orig-type");
        if (origContentType != null && origContentType.length() != 0) {
            return origContentType;
        }
        return super.getContentType();
    }

    public String getStringHeader(String name) throws IOException {
        if ("Content-type".equalsIgnoreCase(name)) {
            return this.getContentType();
        }
        return super.getStringHeader(name);
    }
}

