/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class KDCConfig {
    private static KDCConfig instance;
    private Hashtable propertiesTable;
    private String realm;

    public static KDCConfig getInstance() {
        if (instance != null) {
            return instance;
        }
        instance = new KDCConfig();
        return instance;
    }

    private KDCConfig() {
        String kdc = System.getProperty("java.security.krb5.kdc");
        this.realm = System.getProperty("java.security.krb5.realm");
        if (this.realm != null) {
            if (kdc == null) {
                throw new RuntimeException("property java.security.krb5.kdc is not set\nwhile java.security.krb5.realm is set. You have to set both properties or none of them.");
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("default_realm", this.realm);
            hashtable.put("kdc", kdc);
            this.propertiesTable = new Hashtable();
            this.propertiesTable.put("libdefaults", hashtable);
        } else {
            if (kdc != null) {
                throw new RuntimeException("System property java.security.krb5.realm is not set.while java.security.krb5.kdc is set. You have to set both properties or none of them");
            }
            try {
                Vector vector = this.configFileToVector();
                this.propertiesTable = this.vectorToTable(vector);
            }
            catch (IOException ioexception) {
                RuntimeException krbexception = new RuntimeException(" Could not load configuration file " + ioexception.getMessage());
                throw krbexception;
            }
        }
    }

    public String getDefault(String s) {
        if (this.propertiesTable == null) {
            return null;
        }
        return this.getDefault(s, this.propertiesTable);
    }

    private String getDefault(String property, Hashtable hashtable) {
        String s1 = null;
        if (this.propertiesTable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String s2 = (String)enumeration.nextElement();
                Object obj = hashtable.get(s2);
                if (obj instanceof Hashtable) {
                    s1 = this.getDefault(property, (Hashtable)obj);
                    if (s1 == null) continue;
                    return s1;
                }
                if (!s2.equalsIgnoreCase(property)) continue;
                if (obj instanceof String) {
                    return (String)hashtable.get(s2);
                }
                if (!(obj instanceof Vector)) continue;
                s1 = "";
                int i = ((Vector)obj).size();
                int j = 0;
                while (j < i) {
                    s1 = j == i - 1 ? s1 + (String)((Vector)obj).elementAt(j) : s1 + (String)((Vector)obj).elementAt(j) + " ";
                    ++j;
                }
                return s1;
            }
        }
        return s1;
    }

    public String getPropertyValue(String property, String section) {
        String value = null;
        if (property.equalsIgnoreCase("kdc") && !section.equalsIgnoreCase("libdefaults") && System.getProperty("java.security.krb5.kdc") != null) {
            value = this.getPropertyValue("kdc", "libdefaults");
            return value;
        }
        if (this.propertiesTable != null) {
            Enumeration enumeration = this.propertiesTable.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable1;
                Object obj;
                String currentSec = (String)enumeration.nextElement();
                Hashtable hashtable = (Hashtable)this.propertiesTable.get(currentSec);
                if (currentSec.equalsIgnoreCase(section)) {
                    if (!hashtable.containsKey(property)) continue;
                    return (String)hashtable.get(property);
                }
                if (!hashtable.containsKey(section) || !((obj = hashtable.get(section)) instanceof Hashtable) || !(hashtable1 = (Hashtable)obj).containsKey(property)) continue;
                Object obj1 = hashtable1.get(property);
                if (obj1 instanceof Vector) {
                    value = "";
                    int i = ((Vector)obj1).size();
                    int j = 0;
                    while (j < i) {
                        value = j == i - 1 ? value + (String)((Vector)obj1).elementAt(j) : value + (String)((Vector)obj1).elementAt(j) + " ";
                        ++j;
                    }
                    continue;
                }
                value = (String)obj1;
            }
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    private Vector configFileToVector() throws IOException {
        String s;
        String fileName = this.getConfigFileName();
        if (fileName == null || fileName.length() == 0) {
            return null;
        }
        BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        Vector<String> vector = new Vector<String>();
        while ((s = bufferedreader.readLine()) != null) {
            void var4_4;
            if (var4_4.startsWith("#")) continue;
            vector.addElement(var4_4.trim());
        }
        bufferedreader.close();
        return vector;
    }

    private Hashtable vectorToTable(Vector vector) {
        if (vector == null) {
            throw new RuntimeException("I/O error while reading configuration file.");
        }
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        int i = 0;
        while (i < vector.size()) {
            String s = ((String)vector.elementAt(i)).trim();
            if (s.equalsIgnoreCase("[realms]")) {
                int j = i + 1;
                while (j < vector.size() + 1) {
                    if (j == vector.size() || ((String)vector.elementAt(j)).startsWith("[")) {
                        Hashtable hashtable1 = new Hashtable();
                        hashtable1 = this.createRealmProperties(vector, i + 1, j);
                        hashtable.put("realms", hashtable1);
                        i = j - 1;
                        break;
                    }
                    ++j;
                }
            } else if (s.equalsIgnoreCase("[capaths]")) {
                int k = i + 1;
                while (k < vector.size() + 1) {
                    if (k == vector.size() || ((String)vector.elementAt(k)).startsWith("[")) {
                        Hashtable hashtable2 = new Hashtable();
                        hashtable2 = this.createRealmProperties(vector, i + 1, k);
                        hashtable.put("capaths", hashtable2);
                        i = k - 1;
                        break;
                    }
                    ++k;
                }
            } else if (s.startsWith("[") && s.endsWith("]")) {
                String s1 = s.substring(1, s.length() - 1);
                int l = i + 1;
                while (l < vector.size() + 1) {
                    if (l == vector.size() || ((String)vector.elementAt(l)).startsWith("[")) {
                        Hashtable hashtable3 = this.createSectionProperties(vector, i + 1, l);
                        hashtable.put(s1, hashtable3);
                        i = l - 1;
                        break;
                    }
                    ++l;
                }
            }
            ++i;
        }
        return hashtable;
    }

    private String getConfigFileName() {
        String ret = System.getProperty("java.security.krb5.conf");
        if (ret != null && new File(ret).exists()) {
            return ret;
        }
        ret = System.getProperty("java.home") + File.separator + "lib" + File.separator + "security" + File.separator + "krb5.conf";
        if (ret != null && new File(ret).exists()) {
            return ret;
        }
        String osName = System.getProperty("os.name");
        if (osName.startsWith("Windows")) {
            ret = "c:\\winnt\\krb5.ini";
        } else if (osName.startsWith("SunOS")) {
            ret = "/etc/krb5/krb5.conf";
        } else if (osName.startsWith("Linux")) {
            ret = "/etc/krb5.conf";
        }
        return ret;
    }

    private Hashtable createSectionProperties(Vector vector, int firstIdx, int lastIdx) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        int k = firstIdx;
        while (k < lastIdx) {
            String s = (String)vector.elementAt(k);
            int l = 0;
            while (l < s.length()) {
                if (s.charAt(l) == '=') {
                    String s1 = s.substring(0, l).trim();
                    String s2 = s.substring(l + 1).trim();
                    hashtable.put(s1, s2);
                    break;
                }
                ++l;
            }
            ++k;
        }
        return hashtable;
    }

    private Hashtable createRealmProperties(Vector vector, int firstIdx, int lastIdx) {
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        int k = firstIdx;
        while (k < lastIdx) {
            String s = ((String)vector.elementAt(k)).trim();
            if (s.endsWith("{")) {
                String s2 = "";
                int l = 0;
                while (l < s.length()) {
                    if (s.charAt(l) == '=') {
                        s2 = s.substring(0, l).trim();
                        break;
                    }
                    ++l;
                }
                int i1 = k + 1;
                while (i1 < lastIdx) {
                    boolean flag = false;
                    String s1 = ((String)vector.elementAt(i1)).trim();
                    int j1 = 0;
                    while (j1 < s1.length()) {
                        if (s1.charAt(j1) == '}') {
                            flag = true;
                            break;
                        }
                        ++j1;
                    }
                    if (flag) {
                        Hashtable hashtable1 = this.createNestedRealmProperties(vector, k + 1, i1);
                        hashtable.put(s2, hashtable1);
                        k = i1;
                        flag = false;
                        break;
                    }
                    ++i1;
                }
            }
            ++k;
        }
        return hashtable;
    }

    private Hashtable createNestedRealmProperties(Vector vector, int firstIdx, int lastIdx) {
        Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
        Vector<String> vector1 = new Vector<String>();
        int k = firstIdx;
        while (k < lastIdx) {
            String s1 = (String)vector.elementAt(k);
            int l = 0;
            while (l < s1.length()) {
                if (s1.charAt(l) == '=') {
                    Vector<String> vector3;
                    String s2 = s1.substring(0, l - 1).trim();
                    if (!vector1.contains(s2)) {
                        vector1.addElement(s2);
                        vector3 = new Vector<String>();
                    } else {
                        vector3 = (Vector<String>)hashtable.get(s2);
                    }
                    vector3.addElement(s1.substring(l + 1).trim());
                    hashtable.put(s2, vector3);
                    break;
                }
                ++l;
            }
            ++k;
        }
        return hashtable;
    }

    public String getDefaultRealm() {
        if (this.realm == null) {
            this.realm = this.getPropertyValue("default_realm", "libdefaults");
        }
        return this.realm;
    }

    public String getMasterKDC(String section) {
        String s1;
        if (section == null) {
            section = this.getDefaultRealm();
        }
        if ((s1 = this.getPropertyValue("kdc", section)) == null) {
            return null;
        }
        int i = s1.indexOf(32);
        if (i != -1) {
            return s1.substring(0, i);
        }
        return s1;
    }
}

