/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils;

import com.idoox.wasp.security.kerberos.utils.asn1.DerValue;
import com.idoox.wasp.security.kerberos.utils.asn1.ObjectIdentifier;
import java.io.IOException;
import java.io.InputStream;
import org.ietf.jgss.GSSException;

public class GSSHeader {
    private ObjectIdentifier mechOid = null;
    private byte[] mechOidBytes = null;
    private int mechTokenLength = 0;
    public static final int TOKEN_ID = 96;

    public GSSHeader(InputStream inputstream) throws IOException, GSSException {
        int i = inputstream.read();
        if (i != 96) {
            throw new GSSException(10, -1, "GSSHeader did not find the right tag");
        }
        int j = this.getLength(inputstream);
        DerValue dervalue = new DerValue(inputstream);
        this.mechOidBytes = dervalue.toByteArray();
        this.mechOid = dervalue.getOID();
        this.mechTokenLength = j - this.mechOidBytes.length;
    }

    private int getLength(InputStream inputstream) throws IOException {
        return this.getLength(inputstream.read(), inputstream);
    }

    private int getLength(int i, InputStream inputstream) throws IOException {
        int j;
        int k = i;
        if ((k & 0x80) == 0) {
            j = k;
        } else {
            if ((k &= 0x7F) == 0) {
                return -1;
            }
            if (k < 0 || k > 4) {
                throw new IOException("DerInputStream.getLength(): lengthTag=" + k + ", " + (k >= 0 ? "too big." : "incorrect DER encoding."));
            }
            j = 0;
            while (k > 0) {
                j <<= 8;
                j += 0xFF & inputstream.read();
                --k;
            }
        }
        return j;
    }
}

