/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils.asn1;

import java.io.IOException;
import java.util.ArrayList;

class DerIndefLenConverter {
    private static final int TAG_MASK = 31;
    private static final int FORM_MASK = 32;
    private static final int CLASS_MASK = 192;
    private static final int LEN_LONG = 128;
    private static final int LEN_MASK = 127;
    private static final int SKIP_EOC_BYTES = 2;
    private byte[] data;
    private byte[] newData;
    private int newDataPos;
    private int dataPos;
    private int dataSize;
    private int index;
    private ArrayList ndefsList = new ArrayList();
    private int numOfTotalLenBytes = 0;

    private boolean isEOC(int i) {
        return (i & 0x1F) == 0 && (i & 0x20) == 0 && (i & 0xC0) == 0;
    }

    static boolean isLongForm(int i) {
        return (i & 0x80) == 128;
    }

    DerIndefLenConverter() {
    }

    static boolean isIndefinite(int i) {
        return DerIndefLenConverter.isLongForm(i) && (i & 0x7F) == 0;
    }

    private void parseTag() throws IOException {
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(this.data[this.dataPos]) && this.data[this.dataPos + 1] == 0) {
            int i = 0;
            Object obj = null;
            int j = this.ndefsList.size() - 1;
            while (j >= 0) {
                obj = this.ndefsList.get(j);
                if (obj instanceof Integer) break;
                i += ((byte[])obj).length - 3;
                --j;
            }
            if (j < 0) {
                throw new IOException("EOC does not have matching indefinite-length tag");
            }
            int k = this.dataPos - (Integer)obj + i;
            byte[] abyte0 = this.getLengthBytes(k);
            this.ndefsList.set(j, abyte0);
            this.numOfTotalLenBytes += abyte0.length - 3;
        }
        ++this.dataPos;
    }

    private void writeTag() {
        byte i;
        if (this.dataPos == this.dataSize) {
            return;
        }
        if (this.isEOC(i = this.data[this.dataPos++]) && this.data[this.dataPos] == 0) {
            ++this.dataPos;
            this.writeTag();
        } else {
            this.newData[this.newDataPos++] = i;
        }
    }

    private int parseLength() throws IOException {
        int j;
        int i = 0;
        if (this.dataPos == this.dataSize) {
            return i;
        }
        if (DerIndefLenConverter.isIndefinite(j = this.data[this.dataPos++] & 0xFF)) {
            this.ndefsList.add(new Integer(this.dataPos));
            return i;
        }
        if (DerIndefLenConverter.isLongForm(j)) {
            if ((j &= 0x7F) > 4) {
                throw new IOException("Too much data");
            }
            if (this.dataSize - this.dataPos < j + 1) {
                throw new IOException("Too little data");
            }
            int k = 0;
            while (k < j) {
                i = (i << 8) + (this.data[this.dataPos++] & 0xFF);
                ++k;
            }
        } else {
            i = j & 0x7F;
        }
        return i;
    }

    private void writeLengthAndValue() throws IOException {
        int j;
        if (this.dataPos == this.dataSize) {
            return;
        }
        int i = 0;
        if (DerIndefLenConverter.isIndefinite(j = this.data[this.dataPos++] & 0xFF)) {
            byte[] abyte0 = (byte[])this.ndefsList.get(this.index++);
            System.arraycopy(abyte0, 0, this.newData, this.newDataPos, abyte0.length);
            this.newDataPos += abyte0.length;
            return;
        }
        if (DerIndefLenConverter.isLongForm(j)) {
            j &= 0x7F;
            int k = 0;
            while (k < j) {
                i = (i << 8) + (this.data[this.dataPos++] & 0xFF);
                ++k;
            }
        } else {
            i = j & 0x7F;
        }
        this.writeLength(i);
        this.writeValue(i);
    }

    private void writeLength(int i) {
        if (i < 128) {
            this.newData[this.newDataPos++] = (byte)i;
        } else if (i < 256) {
            this.newData[this.newDataPos++] = -127;
            this.newData[this.newDataPos++] = (byte)i;
        } else if (i < 65536) {
            this.newData[this.newDataPos++] = -126;
            this.newData[this.newDataPos++] = (byte)(i >> 8);
            this.newData[this.newDataPos++] = (byte)i;
        } else if (i < 0x1000000) {
            this.newData[this.newDataPos++] = -125;
            this.newData[this.newDataPos++] = (byte)(i >> 16);
            this.newData[this.newDataPos++] = (byte)(i >> 8);
            this.newData[this.newDataPos++] = (byte)i;
        } else {
            this.newData[this.newDataPos++] = -124;
            this.newData[this.newDataPos++] = (byte)(i >> 24);
            this.newData[this.newDataPos++] = (byte)(i >> 16);
            this.newData[this.newDataPos++] = (byte)(i >> 8);
            this.newData[this.newDataPos++] = (byte)i;
        }
    }

    private byte[] getLengthBytes(int i) {
        byte[] abyte0;
        int j = 0;
        if (i < 128) {
            abyte0 = new byte[1];
            abyte0[j++] = (byte)i;
        } else if (i < 256) {
            abyte0 = new byte[2];
            abyte0[j++] = -127;
            abyte0[j++] = (byte)i;
        } else if (i < 65536) {
            abyte0 = new byte[3];
            abyte0[j++] = -126;
            abyte0[j++] = (byte)(i >> 8);
            abyte0[j++] = (byte)i;
        } else if (i < 0x1000000) {
            abyte0 = new byte[4];
            abyte0[j++] = -125;
            abyte0[j++] = (byte)(i >> 16);
            abyte0[j++] = (byte)(i >> 8);
            abyte0[j++] = (byte)i;
        } else {
            abyte0 = new byte[5];
            abyte0[j++] = -124;
            abyte0[j++] = (byte)(i >> 24);
            abyte0[j++] = (byte)(i >> 16);
            abyte0[j++] = (byte)(i >> 8);
            abyte0[j++] = (byte)i;
        }
        return abyte0;
    }

    private int getNumOfLenBytes(int i) {
        int byte0 = 0;
        byte0 = i < 128 ? 1 : (i < 256 ? 2 : (i < 65536 ? 3 : (i < 0x1000000 ? 4 : 5)));
        return byte0;
    }

    private void parseValue(int i) {
        this.dataPos += i;
    }

    private void writeValue(int i) {
        int j = 0;
        while (j < i) {
            this.newData[this.newDataPos++] = this.data[this.dataPos++];
            ++j;
        }
    }

    byte[] convert(byte[] abyte0) throws IOException {
        this.data = abyte0;
        this.dataPos = 0;
        this.index = 0;
        this.dataSize = this.data.length;
        boolean flag = false;
        while (this.dataPos < this.dataSize) {
            this.parseTag();
            int i = this.parseLength();
            this.parseValue(i);
        }
        this.newData = new byte[this.dataSize + this.numOfTotalLenBytes];
        this.dataPos = 0;
        this.newDataPos = 0;
        this.index = 0;
        while (this.dataPos < this.dataSize) {
            this.writeTag();
            this.writeLengthAndValue();
        }
        return this.newData;
    }
}

