/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.kerberos.utils.asn1;

import com.idoox.wasp.security.kerberos.utils.asn1.BigInt;
import com.idoox.wasp.security.kerberos.utils.asn1.BitArray;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;

class DerInputBuffer
extends ByteArrayInputStream
implements Cloneable {
    DerInputBuffer(byte[] abyte0) {
        super(abyte0);
    }

    DerInputBuffer(byte[] abyte0, int i, int j) {
        super(abyte0, i, j);
    }

    /*
     * WARNING - void declaration
     */
    DerInputBuffer dup() {
        try {
            void clonenotsupportedexception;
            DerInputBuffer derinputbuffer = (DerInputBuffer)this.clone();
            derinputbuffer.mark(Integer.MAX_VALUE);
            return clonenotsupportedexception;
        }
        catch (CloneNotSupportedException clonenotsupportedexception) {
            throw new IllegalArgumentException(clonenotsupportedexception.toString());
        }
    }

    byte[] toByteArray() {
        int i = this.available();
        if (i <= 0) {
            return null;
        }
        byte[] abyte0 = new byte[i];
        System.arraycopy(this.buf, this.pos, abyte0, 0, i);
        return abyte0;
    }

    int peek() throws IOException {
        if (this.pos >= this.count) {
            throw new IOException("out of data");
        }
        return this.buf[this.pos];
    }

    public boolean equals(Object obj) {
        if (obj instanceof DerInputBuffer) {
            return this.equals((DerInputBuffer)obj);
        }
        return false;
    }

    boolean equals(DerInputBuffer derinputbuffer) {
        if (this == derinputbuffer) {
            return true;
        }
        int i = this.available();
        if (derinputbuffer.available() != i) {
            return false;
        }
        int j = 0;
        while (j < i) {
            if (this.buf[this.pos + j] != derinputbuffer.buf[derinputbuffer.pos + j]) {
                return false;
            }
            ++j;
        }
        return true;
    }

    public int hashCode() {
        int i = 0;
        int j = this.available();
        int k = this.pos;
        int l = 0;
        while (l < j) {
            i += this.buf[k + l] * l;
            ++l;
        }
        return i;
    }

    void truncate(int i) throws IOException {
        if (i > this.available()) {
            throw new IOException("insufficient data");
        }
        this.count = this.pos + i;
    }

    BigInt getUnsigned(int i) throws IOException {
        if (i > this.available()) {
            throw new IOException("short read of integer/enumerated");
        }
        if (this.buf[this.pos] == 0) {
            --i;
            this.skip(1L);
        }
        byte[] abyte0 = new byte[i];
        System.arraycopy(this.buf, this.pos, abyte0, 0, i);
        this.skip(i);
        return new BigInt(abyte0);
    }

    BigInteger getBigInteger(int i) throws IOException {
        if (i > this.available()) {
            throw new IOException("short read of integer");
        }
        if (i == 0) {
            return BigInteger.ZERO;
        }
        byte[] abyte0 = new byte[i];
        System.arraycopy(this.buf, this.pos, abyte0, 0, i);
        this.skip(i);
        return new BigInteger(abyte0);
    }

    byte[] getBitString() {
        if (this.pos >= this.count || this.buf[this.pos] != 0) {
            return null;
        }
        int i = this.available();
        byte[] abyte0 = new byte[i - 1];
        System.arraycopy(this.buf, this.pos + 1, abyte0, 0, i - 1);
        this.pos = this.count;
        return abyte0;
    }

    BitArray getUnalignedBitString() {
        if (this.pos >= this.count) {
            return null;
        }
        int i = this.available();
        byte[] abyte0 = new byte[i - 1];
        int j = abyte0.length * 8 - this.buf[this.pos];
        System.arraycopy(this.buf, this.pos + 1, abyte0, 0, i - 1);
        BitArray bitarray = new BitArray(j, abyte0);
        this.pos = this.count;
        return bitarray;
    }
}

