/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.server;

import com.idoox.debug.Category;
import com.idoox.wasp.config.SecurityModuleConfig;
import com.idoox.wasp.server.config.ServiceBindingConfig;
import java.security.NoSuchProviderException;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.AuthResult;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.server.Current;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspSecurity;
import org.idoox.wasp.config.EndpointCreationListener;
import org.idoox.wasp.server.WSContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ServiceCreationListenerImpl
implements EndpointCreationListener {
    private static final String NO_DEFAULT = "no";
    private static final Category log = Category.getCategory((String)"com.idoox.wasp.security.server.ServiceCreationListenerImpl");
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceBindingConfig;
    static /* synthetic */ Class class$com$idoox$wasp$config$SecurityModuleConfig;

    public void serviceCreated() {
        if (this.configureSecurity()) {
            return;
        }
        this.defaultConfig();
    }

    private boolean configureSecurity() {
        boolean mediatorRequired;
        ServiceBindingConfig.IdentityAssociation[] iasocs;
        String[] providers;
        Current current = Current.getInstance();
        WSContext wsC = WSContext.getInstance();
        String uri = wsC.getPath();
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable conf = Configurator.getConfigurable((String)"ServiceBinding", (String)uri);
        if (conf == null && (conf = Configurator.getConfigurable((String)"GetServiceBinding", (String)uri)) == null) {
            return false;
        }
        ServiceBindingConfig siCfg = (ServiceBindingConfig)conf.narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? (class$com$idoox$wasp$server$config$ServiceBindingConfig = ServiceCreationListenerImpl.class$("com.idoox.wasp.server.config.ServiceBindingConfig")) : class$com$idoox$wasp$server$config$ServiceBindingConfig);
        String initSecProvider = siCfg.getInitiatingSecurityProvider();
        if (initSecProvider != null) {
            if (initSecProvider.length() > 0 && !initSecProvider.equals(NO_DEFAULT)) {
                try {
                    current.setCurrentInitiatingProvider(initSecProvider);
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException("security provider " + initSecProvider + " not found");
                }
            }
        } else {
            this.defaultInitiatingConfig(current);
        }
        if ((providers = siCfg.getAcceptingSecurityProviders()) != null && providers.length != 0) {
            if (providers.length != 1 || providers[0] != null && providers[0].length() != 0 && !providers[0].equals(NO_DEFAULT)) {
                try {
                    current.setCurrentAcceptingProviders(providers);
                }
                catch (NoSuchProviderException e) {
                    throw new RuntimeException("security provider not found " + (e.getMessage() != null ? e.getMessage() : ""));
                }
            }
        } else {
            this.defaultAcceptingConfig(current);
        }
        if ((iasocs = siCfg.getIdentityAssociations()) != null) {
            int numCreds = 0;
            Credentials[] toSet = new Credentials[1];
            int i = 0;
            while (i < iasocs.length) {
                String providerName = iasocs[i].getProviderName();
                String name = iasocs[i].getIdentityName();
                byte[] password = iasocs[i].getPassword();
                try {
                    if (providerName != null && name != null) {
                        PrincipalAuthenticator auth = current.getAuthenticator(providerName);
                        AuthResult result = auth.authenticate(name, password);
                        if (result.resultCode != 0) {
                            log.error("Unable to associate identity with a web service - authentication failure, binding " + conf.getName() + " ,providerName: " + iasocs[i].getProviderName());
                        } else {
                            if (toSet.length == numCreds) {
                                Credentials[] newSet = new Credentials[numCreds * 2];
                                System.arraycopy(toSet, 0, newSet, 0, numCreds);
                                toSet = newSet;
                            }
                            toSet[numCreds] = result.creds;
                            ++numCreds;
                        }
                    } else {
                        log.error("Unable to associate identity with a web service - required parameters are missing,binding: " + conf.getName() + " ,providerName: " + iasocs[i].getProviderName());
                    }
                }
                catch (NoSuchProviderException e) {
                    log.error("There is no authentication provider named " + providerName, (Throwable)e);
                }
                ++i;
            }
            if (numCreds > 0) {
                if (toSet.length != numCreds) {
                    Credentials[] newSet = new Credentials[numCreds];
                    System.arraycopy(toSet, 0, newSet, 0, numCreds);
                    toSet = newSet;
                }
                current.setCredentials(toSet);
            }
        }
        try {
            mediatorRequired = siCfg.isAuthorizationRequired();
        }
        catch (Exception e) {
            mediatorRequired = false;
        }
        try {
            WaspSecurity.setAuthorizationRequired((ServiceEndpointContext)wsC, (boolean)mediatorRequired);
        }
        catch (NoSuchProviderException e) {
            log.error("Unable to set authorization required for endpoint path: " + wsC.getPath(), (Throwable)e);
        }
        return true;
    }

    private void defaultInitiatingConfig(Current current) {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        if (c == null) {
            return;
        }
        SecurityModuleConfig config = (SecurityModuleConfig)c.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = ServiceCreationListenerImpl.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
        String initSecProvider = null;
        try {
            initSecProvider = config.getInitiatingSecurityProvider();
            if (initSecProvider != null) {
                current.setCurrentInitiatingProvider(initSecProvider);
            }
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("security provider " + initSecProvider + " not found");
        }
    }

    private void defaultAcceptingConfig(Current current) {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        if (c == null) {
            return;
        }
        SecurityModuleConfig config = (SecurityModuleConfig)c.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = ServiceCreationListenerImpl.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
        try {
            String[] providers = config.getAcceptingSecurityProviders();
            if (providers != null && providers.length > 0) {
                current.setCurrentAcceptingProviders(providers);
            }
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("security provider not found " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    private void defaultConfig() {
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
        if (c == null) {
            return;
        }
        SecurityModuleConfig config = (SecurityModuleConfig)c.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = ServiceCreationListenerImpl.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
        Current current = Current.getInstance();
        String initSecProvider = null;
        try {
            initSecProvider = config.getInitiatingSecurityProvider();
            if (initSecProvider != null) {
                current.setCurrentInitiatingProvider(initSecProvider);
            }
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("security provider " + initSecProvider + " not found");
        }
        try {
            String[] providers = config.getAcceptingSecurityProviders();
            if (providers != null && providers.length > 0) {
                current.setCurrentAcceptingProviders(providers);
            }
        }
        catch (NoSuchProviderException e) {
            throw new RuntimeException("security provider not found " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

