/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.smanager;

import com.idoox.debug.Category;
import com.idoox.security.spkm.SpkmParseTokenResult;
import com.idoox.security.spkm.SpkmSupport;
import com.idoox.security.util.GSSHelper;
import com.idoox.wasp.Constants;
import com.idoox.wasp.security.smanager.ContextData;
import com.idoox.wasp.server.config.SessionManagerConfig;
import com.systinet.wasp.monitoring.events.LogEventAuthFailed;
import com.systinet.wasp.monitoring.events.LogEventAuthSuccess;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.AuthResult;
import org.idoox.security.Config;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.server.Current;
import org.idoox.transport.Connection;
import org.idoox.transport.InputMessage;
import org.idoox.transport.OutputMessage;
import org.idoox.transport.server.ServerConnection;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.webservice.CallContext;
import org.idoox.webservice.server.Initializable;
import org.idoox.webservice.server.WebServiceContext;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventManager;
import org.systinet.wasp.webservice.RawService;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class SessionManager
implements RawService,
Initializable {
    private static Hashtable contexts = new Hashtable(11, 0.75f);
    private static Hashtable id2Context = new Hashtable(11, 0.75f);
    private static Object CONTEXT_SYNC = new Object();
    private static final Category dbg = Category.getCategory((String)"com.idoox.wasp.security.smanager.SessionManager");
    private long defaultTTL;
    private GSSManager gss;
    private Credentials defaultCreds;
    private static long lastID;
    static /* synthetic */ Class class$org$ietf$jgss$GSSCredential;
    static /* synthetic */ Class class$com$idoox$wasp$security$smanager$SessionManager;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$SessionManagerConfig;

    public void process(Connection connection) {
        ServerConnection serverConnection = (ServerConnection)connection;
        ServiceEndpointContext serviceEndpointContext = (ServiceEndpointContext)CallContext.getInstance().get((Object)CallContext.PARAMETER_HANDLER_WS_CONTEXT);
        if (serviceEndpointContext == null) {
            throw new RuntimeException("Service not found");
        }
        try {
            Object impl = serviceEndpointContext.getServiceEndpoint().getServiceInstance().getImplementationObject();
        }
        catch (Exception e) {
            dbg.debug("Cannot initialize serviceInstance for ", (Throwable)e);
            throw new RuntimeWrappedException("Cannot initialize serviceInstance for " + serviceEndpointContext.getServiceEndpoint().getPath(), (Throwable)e);
        }
        Map serviceData = serviceEndpointContext.getContextData();
        InputMessage inMsg = connection.getInputMessage();
        OutputMessage outMsg = connection.getOutputMessage();
        BufferedInputStream bufIn = new BufferedInputStream((InputStream)connection.getInputMessage());
        SpkmParseTokenResult result = new SpkmParseTokenResult();
        try {
            Credentials[] credentialsArr;
            bufIn.mark(200);
            SpkmSupport.spkmParseToken((InputStream)bufIn, (SpkmParseTokenResult)result);
            bufIn.reset();
            if (result.tokenType != 1) {
                throw new RuntimeException("Invalid token type");
            }
            String sessionID = inMsg.getStringHeader("x-idoox-sessionID");
            GSSContext context = null;
            if (sessionID == null) {
                credentialsArr = (Credentials[])serviceData.get("security.credentials");
                if (credentialsArr == null || credentialsArr.length == 0) {
                    if (this.defaultCreds == null) {
                        throw new RuntimeException("Service is not authenticated and default identity is not configured");
                    }
                    credentialsArr = new Credentials[]{this.defaultCreds};
                    serviceData.put("security.credentials", credentialsArr);
                }
                if (credentialsArr == null) {
                    throw new RuntimeException("Service is not authenticated.");
                }
                Credentials credentials = null;
                GSSCredential cred = null;
                int i = 0;
                while (i < credentialsArr.length) {
                    credentials = credentialsArr[i];
                    Set gssCreds = credentials.getSubject().getPrivateCredentials(class$org$ietf$jgss$GSSCredential == null ? SessionManager.class$("org.ietf.jgss.GSSCredential") : class$org$ietf$jgss$GSSCredential);
                    if (!gssCreds.isEmpty()) {
                        cred = (GSSCredential)gssCreds.iterator().next();
                        break;
                    }
                    ++i;
                }
                if (cred == null) {
                    throw new RuntimeException("Cannot obtain GSSCredential instance from the JAAS Subject\n.Service is not authenticated or the given identity is not created for SPKM mechanism.");
                }
                context = this.gss.createContext(cred);
                Class clazz = class$com$idoox$wasp$security$smanager$SessionManager == null ? (class$com$idoox$wasp$security$smanager$SessionManager = SessionManager.class$("com.idoox.wasp.security.smanager.SessionManager")) : class$com$idoox$wasp$security$smanager$SessionManager;
                synchronized (clazz) {
                    sessionID = Long.toString(++lastID);
                }
                ContextData contextData = new ContextData(credentials, context, this.defaultTTL);
                contextData.sessionID = sessionID;
                Object object = CONTEXT_SYNC;
                synchronized (object) {
                    contexts.put(context, contextData);
                    id2Context.put(sessionID, context);
                }
            }
            credentialsArr = CONTEXT_SYNC;
            synchronized (credentialsArr) {
                context = (GSSContext)id2Context.get(sessionID);
            }
            if (context == null) {
                throw new RuntimeException("Context for session ID " + sessionID + " was not found.");
            }
            outMsg.setStringHeader("x-idoox-sessionID", sessionID);
            outMsg.setContentType("application/binary");
            if (context.isEstablished()) {
                return;
            }
            context.acceptSecContext(bufIn, (OutputStream)outMsg);
            if (context.isEstablished()) {
                ContextData contextData;
                Object object = CONTEXT_SYNC;
                synchronized (object) {
                    contextData = (ContextData)contexts.get(context);
                }
                contextData.state = 2;
                contextData.expireTime = System.currentTimeMillis() / 1000L + contextData.ttl;
                EventManager.fireEvent((Event)new LogEventAuthSuccess(context.getSrcName().toString(), "SPKM", serverConnection.getClientAddress(), connection.getURI().toExternalForm()));
            }
            outMsg.flush();
            outMsg.close();
        }
        catch (GSSException e) {
            EventManager.fireEvent((Event)new LogEventAuthFailed("", "SPKM", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (IOException e) {
            EventManager.fireEvent((Event)new LogEventAuthFailed("", "SPKM", serverConnection.getClientAddress(), connection.getURI().toExternalForm(), (Throwable)e));
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void init(WebServiceContext container) {
        long sweepInterval;
        this.gss = GSSHelper.getManager1((String)Config.getId());
        Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
        Configurable c = Configurator.getConfigurable((String)"SessionManagerConfig", (String)"main");
        if (c == null) {
            this.defaultTTL = 600L;
            sweepInterval = 60L;
        } else {
            SessionManagerConfig config = (SessionManagerConfig)c.narrow(class$com$idoox$wasp$server$config$SessionManagerConfig == null ? (class$com$idoox$wasp$server$config$SessionManagerConfig = SessionManager.class$("com.idoox.wasp.server.config.SessionManagerConfig")) : class$com$idoox$wasp$server$config$SessionManagerConfig);
            try {
                this.defaultTTL = config.getContextTTL();
            }
            catch (Exception e) {
                this.defaultTTL = 600L;
            }
            try {
                sweepInterval = config.getSweepInterval();
            }
            catch (Exception e) {
                sweepInterval = 60L;
            }
            String name = config.getDefaultIdentityName();
            String password = config.getDefaultIdentityPassword();
            if (name != null && password != null) {
                Current current = Current.getInstance();
                PrincipalAuthenticator auth = current.getAuthenticator();
                try {
                    AuthResult result = auth.authenticate(name, password.getBytes(Constants.UTF_8));
                    if (result.resultCode == 0) {
                        this.defaultCreds = result.creds;
                    }
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeWrappedException((Throwable)e);
                }
            }
        }
        Timer timer = (Timer)Context.getInstance((String)"java.util.Timer");
        timer.schedule((TimerTask)new CleanerThread(), sweepInterval * 1000L, sweepInterval * 1000L);
    }

    public void destroy() {
        Iterator it = contexts.keySet().iterator();
        while (it.hasNext()) {
            GSSContext context = (GSSContext)it.next();
            try {
                context.dispose();
            }
            catch (GSSException gSSException) {
                // empty catch block
            }
        }
    }

    public static ContextData getContextData(GSSContext context) {
        ContextData retval;
        Object object = CONTEXT_SYNC;
        synchronized (object) {
            retval = (ContextData)contexts.get(context);
        }
        if (retval == null) {
            return null;
        }
        retval.expireTime = System.currentTimeMillis() / 1000L + retval.ttl;
        return retval;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class CleanerThread
    extends TimerTask {
        CleanerThread() {
        }

        public void run() {
            Object object = CONTEXT_SYNC;
            synchronized (object) {
                Iterator it = contexts.entrySet().iterator();
                long currentTime = System.currentTimeMillis() / 1000L;
                while (it.hasNext()) {
                    Map.Entry entry = it.next();
                    ContextData data = (ContextData)entry.getValue();
                    if (data.expireTime > currentTime) continue;
                    try {
                        data.context.dispose();
                    }
                    catch (GSSException e) {
                        // empty catch block
                    }
                    it.remove();
                    id2Context.remove(data.sessionID);
                }
            }
        }
    }
}

