/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.soapauth;

import com.idoox.wasp.security.soapauth.AuthData;
import com.idoox.wasp.security.soapauth.AuthErrorCode;
import com.idoox.wasp.security.soapauth.AuthenticationHelper;
import com.idoox.wasp.security.soapauth.BasicAuthData;
import com.idoox.wasp.security.soapauth.BasicAuthHeaderElement;
import com.idoox.wasp.security.soapauth.BasicChallengeHeaderElement;
import java.io.IOException;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.MultipleHeadersException;
import org.idoox.xmlrpc.header.HeaderProcessingException;

public class ClientBasicAuthentication {
    public static void processOutput(Message message) throws MultipleHeadersException, TokenizerException, IOException, HeaderProcessingException, MessageProcessingException {
        AuthData ad = AuthenticationHelper.getClientAuthData(null);
        if (ad == null) {
            return;
        }
        if (!(ad instanceof BasicAuthData)) {
            throw new HeaderProcessingException("no basic authentication data availabe");
        }
        BasicAuthData authData = (BasicAuthData)ad;
        BasicAuthHeaderElement bahe = new BasicAuthHeaderElement(authData.getUserName(), authData.getPassword());
        message.addHeader(bahe.getTokenizer());
    }

    public static void processInputFault(Message message) throws MultipleHeadersException, TokenizerException, IOException, HeaderProcessingException {
        BasicChallengeHeaderElement bche = BasicChallengeHeaderElement.getBasicAuthHeaderElement(message);
        if (bche == null) {
            return;
        }
        AuthData authData = AuthenticationHelper.getClientAuthData(null);
        if (authData != null) {
            authData.setErrorCode(new AuthErrorCode(2, bche.getRealm()));
        }
        throw new HeaderProcessingException("Basic challenge is wrong. " + bche.getRealm());
    }
}

