/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security.soapauth;

import com.idoox.wasp.security.soapauth.AuthData;
import com.idoox.wasp.security.soapauth.AuthenticationHelper;
import com.idoox.wasp.security.soapauth.ServerBasicAuthentication;
import com.idoox.wasp.security.soapauth.ServerDigestAuthentication;
import org.idoox.xmlrpc.Message;
import org.idoox.xmlrpc.header.HeaderProcessingException;
import org.idoox.xmlrpc.header.HeaderProcessor;

public class ServerHeaderProcessor
implements HeaderProcessor {
    public void processInput(Message message) throws HeaderProcessingException {
        AuthData authData = AuthenticationHelper.getServerAuthData();
        if (authData.getAuthType() == 2) {
            return;
        }
        try {
            if (authData.getAuthType() == 0) {
                ServerDigestAuthentication.processInput(message);
                return;
            }
            if (authData.getAuthType() == 1) {
                ServerBasicAuthentication.processInput(message);
                return;
            }
        }
        catch (HeaderProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HeaderProcessingException("Error processing authentication. " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    public void processOutput(Message message) throws HeaderProcessingException {
        AuthData authData = AuthenticationHelper.getServerAuthData();
        try {
            if (authData.getAuthType() == 2) {
                return;
            }
            if (authData.getAuthType() == 0) {
                ServerDigestAuthentication.processOutput(message);
                return;
            }
            if (authData.getAuthType() == 1) {
                return;
            }
        }
        catch (HeaderProcessingException e) {
            throw e;
        }
        catch (Exception e) {
            throw new HeaderProcessingException("Error processing authentication. " + (e.getMessage() != null ? e.getMessage() : ""));
        }
    }

    public void processInputFault(Message message) throws HeaderProcessingException {
        throw new HeaderProcessingException("invalid direction");
    }

    public void processOutputFault(Message message) throws HeaderProcessingException {
        throw new HeaderProcessingException("invalid direction");
    }
}

