/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.security.util.CertUtil;
import com.idoox.wasp.Constants;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.SignatureException;

public class BinaryLicense {
    private X509Certificate certificate = null;
    Map contentData = null;

    public BinaryLicense(Tokenizer tokenizer, Map contentData) throws SignatureException {
        try {
            String checkCert;
            Token token = new Token();
            tokenizer.readToken(token);
            String valueType = token.getAttributeValue("http://schemas.xmlsoap.org/ws/2001/10/license", "valueType");
            if (valueType == null) {
                throw new SignatureException("ValueType of the BinaryLicense is unknown");
            }
            if (!valueType.equals("wslic:x509v3")) {
                throw new SignatureException("This type of BinaryLicense is not implemented.");
            }
            tokenizer.next();
            String content = tokenizer.readContent();
            String wrappedContent = "-----BEGIN CERTIFICATE-----\n" + content + "\n-----END CERTIFICATE-----\n";
            ByteArrayInputStream stream = new ByteArrayInputStream(wrappedContent.getBytes(Constants.UTF_8));
            this.certificate = (X509Certificate)CertificateFactory.getInstance("X.509").generateCertificate(stream);
            tokenizer.next();
            this.contentData = contentData;
            if (this.contentData != null && (checkCert = (String)contentData.get("NO_CHECK_TRUSTED_CERTIFICATE")) != null && checkCert.equals("true")) {
                return;
            }
            boolean ret = CertUtil.IsCertTrusted((X509Certificate)this.certificate);
            if (!ret) {
                throw new SignatureException("Certificate is not trusted.");
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating BinaryLicense. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public PublicKey getPublicKey() throws SignatureException {
        return this.certificate.getPublicKey();
    }

    public Certificate[] getCertificates() {
        return new Certificate[]{this.certificate};
    }
}

