/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.security.util.DssSig;
import com.idoox.wasp.Constants;
import com.idoox.xml.security.SignatureValue;
import com.idoox.xml.security.SignedInfo;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.PrivateKey;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.security.SignatureException;

public class DSASignatureValue
extends SignatureValue {
    public DSASignatureValue() {
        this.signatureAlgorithmId = "SHA1withDSA";
    }

    public String getSignatureValue(SignedInfo signedInfo, PrivateKey privateKey) throws SignatureException {
        try {
            byte[] bytesValue = this.getSignatureBytesValue(signedInfo, privateKey);
            DssSig dss = new DssSig(bytesValue);
            byte[] bytesR = dss.getR().toByteArray();
            byte[] bytesS = dss.getS().toByteArray();
            bytesR = this.truncateArray(bytesR);
            bytesS = this.truncateArray(bytesS);
            byte[] xmlBytesValue = new byte[40];
            System.arraycopy(bytesR, 0, xmlBytesValue, 0, 20);
            System.arraycopy(bytesS, 0, xmlBytesValue, 20, 20);
            byte[] signedValueArr64 = Base64.encode((byte[])xmlBytesValue, (boolean)false);
            return new String(signedValueArr64, Constants.UTF_8);
        }
        catch (Exception e) {
            throw new SignatureException("Error creating DSASignatureValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    private byte[] truncateArray(byte[] array) {
        byte[] ret = new byte[20];
        int i = 0;
        while (i < 20) {
            ret[i] = 0;
            ++i;
        }
        if (array.length > 20) {
            System.arraycopy(array, array.length - 20, ret, 0, 20);
        } else {
            System.arraycopy(array, 0, ret, 20 - array.length, array.length);
        }
        return ret;
    }

    protected byte[] getSignatureBytes(String signatureValue) throws SignatureException {
        try {
            byte[] rsbytes = Base64.decode((byte[])signatureValue.getBytes(Constants.UTF_8));
            if (rsbytes.length != 40) {
                throw new SignatureException("Incorrect signature value.");
            }
            byte[] rbytes = new byte[21];
            byte[] sbytes = new byte[21];
            rbytes[0] = 0;
            sbytes[0] = 0;
            System.arraycopy(rsbytes, 0, rbytes, 1, 20);
            System.arraycopy(rsbytes, 20, sbytes, 1, 20);
            DssSig dss = new DssSig(new BigInteger(rbytes), new BigInteger(sbytes));
            byte[] asn1Bytes = dss.encode();
            return asn1Bytes;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }
}

