/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.xml.security.SignatureBase;
import com.idoox.xml.security.TokenizerUtil;
import java.util.Map;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.security.KeyContentFactory;
import org.idoox.xml.security.KeyValueContent;
import org.idoox.xml.security.SignatureException;

public class KeyValue
extends SignatureBase {
    private Map keyContentsMap = null;
    Vector keyValueContents = new Vector();

    public static KeyValueContent[] getKeyValueContents(Tokenizer tokenizedKeyValue, Map keyContentsMap) throws SignatureException {
        KeyValue keyValue = new KeyValue(tokenizedKeyValue, keyContentsMap);
        if (keyValue.keyValueContents.size() == 0) {
            return null;
        }
        KeyValueContent[] ret = new KeyValueContent[keyValue.keyValueContents.size()];
        keyValue.keyValueContents.toArray(ret);
        return ret;
    }

    public KeyValue(Tokenizer tokenizer, Map keyContentsMap) throws SignatureException {
        this.keyContentsMap = keyContentsMap;
        try {
            TokenizerUtil.constructChildrenElements(this, tokenizer);
        }
        catch (Exception e) {
            throw new SignatureException("Error creating KeyValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public boolean constructElement(Tokenizer tokenizer) throws SignatureException {
        try {
            QName qName = new QName(tokenizer.getNamespace(), tokenizer.getLocalName());
            KeyValueContent keyValueContent = (KeyValueContent)KeyContentFactory.getKeyContent(qName);
            if (keyValueContent == null) {
                return false;
            }
            if (this.keyContentsMap != null && this.keyContentsMap.containsKey(qName)) {
                keyValueContent.setContentData((Map)this.keyContentsMap.get(qName));
            }
            keyValueContent.construct(tokenizer);
            this.keyValueContents.add(keyValueContent);
            return true;
        }
        catch (Exception e) {
            throw new SignatureException("Error creating KeyValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }
}

