/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.debug.Category;
import com.idoox.wasp.Constants;
import com.idoox.xml.security.DSASignatureValue;
import com.idoox.xml.security.HmacSignatureValue;
import com.idoox.xml.security.KeyInfo;
import com.idoox.xml.security.RSASignatureValue;
import com.idoox.xml.security.SignedInfo;
import java.io.UnsupportedEncodingException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import javax.crypto.SecretKey;
import org.idoox.util.Base64;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.security.SignatureException;

public class SignatureValue {
    protected String signatureAlgorithmId = null;
    private static final Category log = Category.getCategory((String)"com.idoox.xml.security.SignatureValue");

    public static SignatureValue getInstance(String signatureAlgorithm) throws SignatureException {
        if (signatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#dsa-sha1")) {
            return new DSASignatureValue();
        }
        if (signatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#rsa-sha1")) {
            return new RSASignatureValue();
        }
        if (signatureAlgorithm.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
            return new HmacSignatureValue();
        }
        throw new SignatureException("Error during getSignatureValue. This signature algorithm not implemented");
    }

    public String getSignatureValue(SignedInfo signedInfo, PrivateKey privateKey) throws SignatureException {
        byte[] bytesValue = this.getSignatureBytesValue(signedInfo, privateKey);
        byte[] signedValueArr64 = Base64.encode((byte[])bytesValue, (boolean)false);
        try {
            return new String(signedValueArr64, Constants.UTF_8);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String getSignatureValue(SignedInfo signedInfo, SecretKey secretKey) throws SignatureException {
        throw new SignatureException("This method should be implemented by extended class.");
    }

    protected byte[] getSignatureBytesValue(SignedInfo signedInfo, PrivateKey privateKey) throws SignatureException {
        try {
            Signature signature = Signature.getInstance(this.signatureAlgorithmId);
            signature.initSign(privateKey);
            byte[] signedInfoArr = signedInfo.getBytes();
            signature.update(signedInfoArr);
            return signature.sign();
        }
        catch (Exception e) {
            throw new SignatureException("Error creating SignatureValue. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public boolean verify(SignedInfo signedInfo, KeyInfo keyInfo, String signatureValue) {
        try {
            PublicKey publicKey = keyInfo.getPublicKey();
            Signature signature = Signature.getInstance(this.signatureAlgorithmId);
            signature.initVerify(publicKey);
            signature.update(signedInfo.getBytes());
            return signature.verify(this.getSignatureBytes(signatureValue));
        }
        catch (Exception e) {
            log.error("error during check signature value", (Throwable)e);
            return false;
        }
    }

    public boolean verify(SignedInfo signedInfo, SecretKey secretKey, String signatureValue) {
        try {
            String realSignatureValue = this.getSignatureValue(signedInfo, secretKey);
            return realSignatureValue.equals(signatureValue);
        }
        catch (Exception e) {
            log.error("error during check signature value", (Throwable)e);
            return false;
        }
    }

    protected byte[] getSignatureBytes(String signatureValue) throws SignatureException {
        try {
            return Base64.decode((byte[])signatureValue.getBytes(Constants.UTF_8));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }
}

