/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.xml.security;

import com.idoox.wasp.Constants;
import com.idoox.xml.CachingTokenizer;
import com.idoox.xml.ReaderTokenizer;
import com.idoox.xml.security.Reference;
import com.idoox.xml.security.SignatureBase;
import com.idoox.xml.security.TokenizerUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerResolver;
import org.idoox.xml.security.ReferencedData;
import org.idoox.xml.security.SignatureException;

public class SignedInfo
extends SignatureBase {
    ReferencedData dataSource;
    byte[] signedInfoBytes = null;
    Reference[] references;
    String signatureMethod;
    String canonicalizationMethod;
    String hmacOutputLength = null;
    String signaturePrefix = "";
    Map ancestorNS = null;

    public SignedInfo(ReferencedData dataSource, Reference[] references, String signatureMethod, String canonicalizationMethod, String signaturePrefix, Map ancestorNS) {
        this.dataSource = dataSource;
        this.references = references;
        if (signatureMethod != null) {
            this.signatureMethod = signatureMethod;
        }
        if (canonicalizationMethod != null) {
            this.canonicalizationMethod = canonicalizationMethod;
        }
        this.signaturePrefix = signaturePrefix;
        this.ancestorNS = ancestorNS;
    }

    public SignedInfo(ReferencedData dataSource, Tokenizer tokenizedSignedInfo) throws SignatureException {
        try {
            this.dataSource = dataSource;
            CachingTokenizer ct = new CachingTokenizer(tokenizedSignedInfo);
            ct.fillCache();
            this.ancestorNS = ct.getCurrentPrefixMap();
            Token tk = new Token();
            ct.readToken(tk);
            if (tk.prefix != null) {
                this.signaturePrefix = tk.prefix;
            }
            this.signedInfoBytes = TokenizerResolver.toCanonicalForm((Tokenizer)ct, (boolean)true);
            ReaderTokenizer rd = new ReaderTokenizer((InputStream)new ByteArrayInputStream(this.signedInfoBytes));
            rd.next();
            TokenizerUtil.constructChildrenElements(this, (Tokenizer)rd);
        }
        catch (Exception e) {
            throw new SignatureException("Error creating SignedInfo. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
    }

    public boolean constructElement(Tokenizer tokenizer) throws SignatureException {
        try {
            String name = tokenizer.getLocalName();
            Token token = new Token();
            if (name.equals("SignatureMethod")) {
                tokenizer.readToken(token);
                this.signatureMethod = token.getAttributeValue(null, "Algorithm");
                if (this.signatureMethod.equals("http://www.w3.org/2000/09/xmldsig#hmac-sha1")) {
                    TokenizerUtil.constructChildrenElements(this, tokenizer);
                } else {
                    tokenizer.next();
                }
                return true;
            }
            if (name.equals("CanonicalizationMethod")) {
                tokenizer.readToken(token);
                this.canonicalizationMethod = token.getAttributeValue(null, "Algorithm");
                tokenizer.next();
                return true;
            }
            if (name.equals("Reference")) {
                Reference ref = new Reference(this.dataSource, tokenizer);
                this.addReference(ref);
                return true;
            }
            if (name.equals("HMACOutputLength")) {
                tokenizer.next();
                this.hmacOutputLength = tokenizer.readContent();
                tokenizer.next();
            }
        }
        catch (Exception e) {
            throw new SignatureException("Error creating SignedInfo. " + (e.getMessage() != null ? e.getMessage() : ""), e);
        }
        return false;
    }

    public String getSignatureMethod() {
        return this.signatureMethod;
    }

    public String toCanonicalXMLString() throws SignatureException {
        return this.toCanonicalXMLString(false, false);
    }

    public String toCanonicalXMLString(boolean addSignaturePrefix, boolean addAncestorNS) throws SignatureException {
        StringBuffer sb = new StringBuffer();
        String startTag = "";
        String endTag = "";
        if (!this.signaturePrefix.equals("")) {
            startTag = "<" + this.signaturePrefix + ":";
            endTag = "</" + this.signaturePrefix + ":";
        } else {
            startTag = "<";
            endTag = "</";
        }
        if (!addSignaturePrefix) {
            sb.append(startTag).append("SignedInfo");
        } else if (this.signaturePrefix.equals("")) {
            sb.append(startTag).append("SignedInfo xmlns=\"http://www.w3.org/2000/09/xmldsig#\"");
        } else {
            sb.append(startTag).append("SignedInfo xmlns:").append(this.signaturePrefix).append("=\"http://www.w3.org/2000/09/xmldsig#\"");
        }
        if (addAncestorNS && this.ancestorNS != null && this.ancestorNS.size() > 0) {
            try {
                if (this.ancestorNS.containsKey(null)) {
                    this.ancestorNS.remove(null);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            TreeMap sortedMap = new TreeMap(this.ancestorNS);
            Iterator it = sortedMap.keySet().iterator();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                String value = (String)sortedMap.get(prefix);
                if (prefix != null && prefix.equals(this.signaturePrefix)) continue;
                sb.append(" xmlns:").append(prefix).append("=\"").append(value).append("\"");
            }
        }
        sb.append(">\n");
        sb.append(startTag).append("CanonicalizationMethod Algorithm=\"" + this.canonicalizationMethod + "\">").append(endTag).append("CanonicalizationMethod>\n");
        if (this.hmacOutputLength == null) {
            sb.append(startTag).append("SignatureMethod Algorithm=\"").append(this.signatureMethod).append("\">").append(endTag).append("SignatureMethod>\n");
        } else {
            sb.append(startTag).append("SignatureMethod Algorithm=\"" + this.signatureMethod + "\">\n");
            sb.append(startTag).append("HMACOutputLength>").append(this.hmacOutputLength).append(endTag).append("HMACOutputLength>\n");
            sb.append(endTag).append("SignatureMethod>\n");
        }
        int i = 0;
        while (i < this.references.length) {
            sb.append(this.references[i].toCanonicalXMLString());
            ++i;
        }
        sb.append(endTag).append("SignedInfo>");
        return sb.toString();
    }

    public byte[] getBytes() throws SignatureException, UnsupportedEncodingException {
        if (this.canonicalizationMethod != null && this.canonicalizationMethod.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315")) {
            return this.toCanonicalXMLString(true, true).getBytes(Constants.UTF_8);
        }
        return this.toCanonicalXMLString(true, false).getBytes(Constants.UTF_8);
    }

    private void addReference(Reference ref) {
        if (this.references == null || this.references.length == 0) {
            this.references = new Reference[1];
            this.references[0] = ref;
            return;
        }
        Reference[] newReferences = new Reference[this.references.length + 1];
        System.arraycopy(this.references, 0, newReferences, 0, this.references.length);
        newReferences[this.references.length] = ref;
        this.references = newReferences;
    }

    public boolean verify() {
        int i = 0;
        while (i < this.references.length) {
            if (!this.references[i].verify()) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

