/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.security;

import com.idoox.debug.Category;
import com.idoox.security.jaas.HttpCredential;
import com.idoox.wasp.Constants;
import com.idoox.wasp.config.SecurityModuleConfig;
import com.idoox.wasp.security.SecurityProvidersConfigs;
import com.idoox.wasp.security.server.CurrentImpl;
import com.idoox.wasp.server.config.ServiceBindingConfig;
import com.systinet.security.server.AZServiceMediator;
import com.systinet.wasp.bc.SysServices;
import com.systinet.wasp.monitoring.events.LogEventAZFailed;
import com.systinet.wasp.monitoring.events.LogEventAZSuccess;
import com.systinet.wasp.webservice.ServiceEndpointImpl;
import java.io.UnsupportedEncodingException;
import java.security.AccessControlException;
import java.security.NoSuchProviderException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Principal;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.Subject;
import org.idoox.config.Configurable;
import org.idoox.config.Configurator;
import org.idoox.security.AuthResult;
import org.idoox.security.Credentials;
import org.idoox.security.PrincipalAuthenticator;
import org.idoox.security.server.ReceivedCredentials;
import org.idoox.security.spi.ClientSecurityProvider;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.WaspSecurity;
import org.idoox.wasp.security.kerberos.KerberosConfig;
import org.idoox.webservice.client.WebServiceLookupException;
import org.systinet.monitoring.Event;
import org.systinet.monitoring.EventManager;
import org.systinet.security.policy.UpdateablePolicy;
import org.systinet.security.policy.WASPAccessController;
import org.systinet.wasp.admin.SecurityInfoService;
import org.systinet.wasp.admin.ServiceEndpoint;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.LookupException;
import org.systinet.wasp.webservice.ServiceClient;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class WaspSecurityImpl
extends WaspSecurity.SPI {
    private static final Category cat = Category.getCategory((String)"com.systinet.security.WaspSecurityImpl");
    private Map installedSecurity;
    static /* synthetic */ Class class$com$idoox$security$jaas$HttpCredential;
    static /* synthetic */ Class class$org$idoox$wasp$security$kerberos$KerberosConfig;
    static /* synthetic */ Class class$com$idoox$wasp$security$SecurityProvidersConfigs;
    static /* synthetic */ Class class$com$idoox$wasp$server$config$ServiceBindingConfig;
    static /* synthetic */ Class class$com$idoox$wasp$config$SecurityModuleConfig;

    public WaspSecurityImpl() {
        HashMap<String, String> map = new HashMap<String, String>(3);
        map.put("AUTHENTICATION_SUPPORTED", "true");
        map.put("AUTHORIZATION_SUPPORTED", "true");
        this.installedSecurity = Collections.unmodifiableMap(map);
    }

    public Map getInstalledSecurityInfo() {
        return this.installedSecurity;
    }

    public PermissionCollection getDefaultPrincipalPermissions() {
        UpdateablePolicy policy = UpdateablePolicy.getUpdateablePolicy();
        return policy.getPrincipalPermissions(null, null);
    }

    public String getInitiatingProvider(ServiceClient stubConf) {
        if (stubConf == null) {
            org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
            return current.getCurrentProvider();
        }
        return (String)stubConf.getContext().getContextData().get("Stub.securityProvider");
    }

    public String getInitiatingProvider(ServiceEndpointContext wsContext) {
        if (wsContext == null) {
            org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
            return current.getCurrentInitiatingProvider();
        }
        return CurrentImpl.getInitiatingProvider(wsContext);
    }

    public String[] getAcceptingProviders(ServiceEndpointContext wsContext) {
        String[] toRet;
        if (wsContext == null) {
            org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
            toRet = current.getCurrentAcceptingProviders();
        } else {
            toRet = CurrentImpl.getAcceptingProviders(wsContext);
        }
        if (toRet == null) {
            return WaspSecurity.SPI.STRAR_0;
        }
        return toRet;
    }

    public Properties modifyLookupProperties(Properties lookupProperties) {
        org.idoox.security.client.Current current;
        Credentials[] creds;
        if (lookupProperties != null) {
            if (lookupProperties.getProperty("http.basicUserName") != null) {
                return lookupProperties;
            }
        } else {
            lookupProperties = new Properties();
        }
        if ((creds = (current = org.idoox.security.client.Current.getInstance()).getCredentials()) == null || creds.length == 0) {
            return lookupProperties;
        }
        String userName = null;
        String password = null;
        int i = 0;
        while (i < creds.length) {
            if (creds[i] != null && creds[i].getProviderName().equals("HttpBasic")) {
                Subject sub = creds[i].getSubject();
                Set credSet = sub.getPrivateCredentials(class$com$idoox$security$jaas$HttpCredential == null ? WaspSecurityImpl.class$("com.idoox.security.jaas.HttpCredential") : class$com$idoox$security$jaas$HttpCredential);
                if (credSet != null && credSet.size() != 0) {
                    HttpCredential cred = (HttpCredential)credSet.iterator().next();
                    userName = cred.getName();
                    if (userName == null) {
                        userName = "";
                    }
                    if ((password = cred.getPassword()) != null) break;
                    password = "";
                    break;
                }
            }
            ++i;
        }
        if (userName != null) {
            ((Hashtable)lookupProperties).put("http.basicUserName", userName);
            ((Hashtable)lookupProperties).put("http.basicPassword", password);
        }
        return lookupProperties;
    }

    public Subject getInvokerSubject() {
        org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
        ReceivedCredentials creds = current.getReceivedCredentials();
        if (creds == null) {
            return null;
        }
        return creds.getSubject();
    }

    public void setAuthorizationRequired(ServiceEndpointContext seContext, boolean authorizationRequired) throws NoSuchProviderException {
        AZServiceMediator azMediator;
        ServiceEndpointImpl serviceEndpoint = (ServiceEndpointImpl)seContext.getServiceEndpoint();
        List mediators = serviceEndpoint.getMediators();
        if (mediators.contains(azMediator = AZServiceMediator.getSingleton()) != authorizationRequired) {
            if (authorizationRequired) {
                mediators.add(azMediator);
            } else {
                mediators.remove(azMediator);
            }
        }
    }

    public boolean isAuthorizationRequired(ServiceEndpointContext seContext) throws NoSuchProviderException {
        ServiceEndpointImpl serviceEndpoint = (ServiceEndpointImpl)seContext.getServiceEndpoint();
        List mediators = serviceEndpoint.getMediators();
        AZServiceMediator azMediator = AZServiceMediator.getSingleton();
        return mediators.contains(azMediator);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAcceptingProviders(ServiceEndpointContext wsContext, String[] providerNames) throws NoSuchProviderException {
        Map contextData;
        if (wsContext == null) {
            org.idoox.security.server.Current.getInstance().setCurrentAcceptingProviders(providerNames);
            return;
        }
        Map map = contextData = wsContext.getContextData();
        synchronized (map) {
            block7: {
                block6: {
                    Object oldWS = contextData.get("WSCONTEXT_KEY");
                    try {
                        contextData.put("WSCONTEXT_KEY", wsContext);
                        org.idoox.security.server.Current.getInstance().setCurrentAcceptingProviders(providerNames, contextData);
                        Object var7_6 = null;
                        if (oldWS == null) break block6;
                        contextData.put("WSCONTEXT_KEY", oldWS);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (oldWS != null) {
                            contextData.put("WSCONTEXT_KEY", oldWS);
                            throw throwable;
                        }
                        contextData.remove("WSCONTEXT_KEY");
                        throw throwable;
                    }
                }
                contextData.remove("WSCONTEXT_KEY");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setInitiatingProvider(ServiceEndpointContext wsContext, String providerName) throws NoSuchProviderException {
        Map contextData;
        if (wsContext == null) {
            org.idoox.security.client.Current.getInstance().setCurrentProvider(providerName);
            return;
        }
        Map map = contextData = wsContext.getContextData();
        synchronized (map) {
            block7: {
                block6: {
                    Object oldWS = contextData.get("WSCONTEXT_KEY");
                    try {
                        contextData.put("WSCONTEXT_KEY", wsContext);
                        org.idoox.security.server.Current.getInstance().setCurrentInitiatingProvider(providerName, contextData);
                        Object var7_6 = null;
                        if (oldWS == null) break block6;
                        contextData.put("WSCONTEXT_KEY", oldWS);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var7_7 = null;
                        if (oldWS != null) {
                            contextData.put("WSCONTEXT_KEY", oldWS);
                            throw throwable;
                        }
                        contextData.remove("WSCONTEXT_KEY");
                        throw throwable;
                    }
                }
                contextData.remove("WSCONTEXT_KEY");
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setCredentials(ServiceEndpointContext wsContext, Credentials[] creds) {
        Map contextData;
        org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
        if (wsContext == null) {
            if (creds == null) {
                current.resetCredentials();
                return;
            }
            current.setCredentials(creds);
            return;
        }
        Map map = contextData = wsContext.getContextData();
        synchronized (map) {
            block10: {
                block9: {
                    Object oldWS = contextData.get("WSCONTEXT_KEY");
                    try {
                        contextData.put("WSCONTEXT_KEY", wsContext);
                        if (creds == null) {
                            current.resetCredentials(contextData);
                        } else {
                            current.setCredentials(creds, contextData);
                        }
                        Object var8_7 = null;
                        if (oldWS == null) break block9;
                        contextData.put("WSCONTEXT_KEY", oldWS);
                        break block10;
                    }
                    catch (Throwable throwable) {
                        Object var8_8 = null;
                        if (oldWS != null) {
                            contextData.put("WSCONTEXT_KEY", oldWS);
                            throw throwable;
                        }
                        contextData.remove("WSCONTEXT_KEY");
                        throw throwable;
                    }
                }
                contextData.remove("WSCONTEXT_KEY");
            }
            return;
        }
    }

    public Credentials acquireClientCredentials(String userName, String password, String authenticationMechanism) throws NoSuchProviderException {
        org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
        PrincipalAuthenticator auth = authenticationMechanism != null ? current.getAuthenticator(authenticationMechanism) : current.getAuthenticator();
        try {
            AuthResult result = auth.authenticate(userName, password.getBytes(Constants.UTF_8));
            if (result.resultCode != 0) {
                if (result.errorReason != null) {
                    throw result.errorReason;
                }
                throw new RuntimeWrappedException("WaspSecurityImpl.acquireClientCredentials(): authentication failure.");
            }
            Credentials creds = result.creds;
            return creds;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public Credentials acquireServerCredentials(String userName, String password, String authenticationMechanism) throws NoSuchProviderException {
        org.idoox.security.server.Current current = org.idoox.security.server.Current.getInstance();
        PrincipalAuthenticator auth = authenticationMechanism != null ? current.getAuthenticator(authenticationMechanism) : current.getAuthenticator();
        try {
            AuthResult result = auth.authenticate(userName, password.getBytes(Constants.UTF_8));
            if (result.resultCode != 0) {
                if (result.errorReason != null) {
                    throw result.errorReason;
                }
                throw new RuntimeWrappedException("WaspSecurityImpl.acquireServerCredentials(): authentication failed.");
            }
            Credentials creds = result.creds;
            return creds;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public Credentials[] getCredentials(ServiceClient stubConf) {
        if (stubConf == null) {
            org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
            Credentials[] creds = current.getCredentials();
            if (creds == null || creds.length == 0) {
                return null;
            }
            return creds;
        }
        return (Credentials[])stubConf.getContext().getContextData().get("Stub.credentials");
    }

    public void setCredentials(ServiceClient stubConf, Credentials[] creds) {
        if (stubConf == null) {
            org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
            if (creds == null) {
                current.resetCredentials();
            } else {
                current.setCredentials(creds);
            }
            return;
        }
        stubConf.getContext().getContextData().put("Stub.credentials", creds);
    }

    public void setInitiatingProvider(ServiceClient stubConf, String providerName) throws NoSuchProviderException {
        if (stubConf == null) {
            org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
            current.setCurrentProvider(providerName);
            return;
        }
        Map stubContext = stubConf.getContext().getContextData();
        String oldProvider = (String)stubContext.get("Stub.securityProvider");
        HashMap<String, ServiceClient> map = new HashMap<String, ServiceClient>(3);
        map.put("WebServiceStub", stubConf);
        org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
        ClientSecurityProvider p = providerName != null ? current.getProvider(providerName) : null;
        if (oldProvider != null) {
            ClientSecurityProvider oldp = current.getProvider(oldProvider);
            oldp.unsetCurrent(map);
        }
        if (p != null) {
            p.setCurrent(map);
        }
        stubContext.put("Stub.securityProvider", providerName);
    }

    public void setProviderProperties(ServiceClient stubConf, Map properties) {
        Map ctxData = stubConf.getContext().getContextData();
        this.setProviderProperties(ctxData, properties);
    }

    public void setProviderProperties(ServiceEndpointContext wsContext, Map properties) {
        Map ctxData = wsContext.getContextData();
        this.setProviderProperties(ctxData, properties);
    }

    private void setProviderProperties(Map ctxData, Map properties) {
        HashMap props = (HashMap)ctxData.get("SEC_PROVIDER_PROPERTIES");
        if (props == null) {
            props = new HashMap();
            ctxData.put("SEC_PROVIDER_PROPERTIES", props);
        }
        props.putAll(properties);
        if (properties.containsKey("SYSTINET_KRB_PRIVATE_STATE") || properties.containsKey("SYSTINET_KERBEROS_SERVICE_REALM")) {
            Configurable configurable = Configurator.newRuntimeConfigurable();
            KerberosConfig config = (KerberosConfig)configurable.narrow(class$org$idoox$wasp$security$kerberos$KerberosConfig == null ? (class$org$idoox$wasp$security$kerberos$KerberosConfig = WaspSecurityImpl.class$("org.idoox.wasp.security.kerberos.KerberosConfig")) : class$org$idoox$wasp$security$kerberos$KerberosConfig);
            try {
                String privateStr = (String)properties.get("SYSTINET_KRB_PRIVATE_STATE");
                String serviceRealm = (String)properties.get("SYSTINET_KERBEROS_SERVICE_REALM");
                if (privateStr != null && privateStr.equalsIgnoreCase("true")) {
                    config.setPrivateState(true);
                }
                if (privateStr != null && privateStr.equalsIgnoreCase("false")) {
                    config.setPrivateState(false);
                }
                if (serviceRealm != null) {
                    config.setServiceRealm(serviceRealm);
                }
                this.setProviderProperties(ctxData, "Kerberos", configurable);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected void setProviderProperties(ServiceEndpointContext wsContext, Configurable config, String providerName) throws NoSuchProviderException {
        this.setProviderProperties(wsContext.getContextData(), providerName, config);
    }

    protected void setProviderProperties(ServiceClient stubConf, Configurable config, String providerName) throws NoSuchProviderException {
        this.setProviderProperties(stubConf.getContext().getContextData(), providerName, config);
    }

    private void setProviderProperties(Map ctxData, String providerName, Configurable config) {
        HashMap<String, Configurable> props = (HashMap<String, Configurable>)ctxData.get("LOCAL_PROVIDER_CONFIG");
        if (props == null) {
            props = new HashMap<String, Configurable>();
            ctxData.put("LOCAL_PROVIDER_CONFIG", props);
        }
        props.put(providerName, config);
    }

    protected Configurable getProviderProperties(ServiceEndpointContext wsContext, String providerName) {
        Configurable ret = null;
        ret = this.getProviderProperties(wsContext.getContextData(), providerName);
        if (ret != null) {
            return ret;
        }
        return Configurator.getConfigurable((String)"securityProviderPreferences", (String)providerName);
    }

    protected Configurable getProviderProperties(ServiceClient stubConf, String providerName) {
        Configurable ret = null;
        ret = this.getProviderProperties(stubConf.getContext().getContextData(), providerName);
        if (ret != null) {
            return ret;
        }
        ret = this.getProviderProperties(stubConf.getConfigurable(), providerName);
        if (ret != null) {
            return ret;
        }
        ServiceEndpointContext endpointCtx = Current.getServiceEndpointContext();
        if (endpointCtx != null && (ret = this.getProviderProperties(endpointCtx, providerName)) != null) {
            return ret;
        }
        ret = Configurator.getConfigurable((String)"securityProviderPreferences", (String)providerName);
        return ret;
    }

    private void debugProvidersProperties(Configurable config) {
    }

    private Configurable getProviderProperties(Configurable confs, String providerName) {
        if (confs == null) {
            return null;
        }
        SecurityProvidersConfigs providersConfigs = (SecurityProvidersConfigs)confs.narrow(class$com$idoox$wasp$security$SecurityProvidersConfigs == null ? (class$com$idoox$wasp$security$SecurityProvidersConfigs = WaspSecurityImpl.class$("com.idoox.wasp.security.SecurityProvidersConfigs")) : class$com$idoox$wasp$security$SecurityProvidersConfigs);
        SecurityProvidersConfigs.ProviderConfigBase[] providersBases = null;
        providersBases = providersConfigs.getSecurityProviderPreferences();
        if (providersBases != null && providersBases.length > 0) {
            int i = 0;
            while (i < providersBases.length) {
                String tmpName = null;
                try {
                    tmpName = providersBases[i].getLocalName();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (tmpName == null) {
                    try {
                        tmpName = providersBases[i].getName();
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                if (tmpName != null && providerName.equals(tmpName)) {
                    Configurable ret = Configurator.getConfigurable((Object)providersBases[i]);
                    this.debugProvidersProperties(ret);
                    return ret;
                }
                ++i;
            }
        }
        return null;
    }

    private Configurable getProviderProperties(Map ctxData, String providerName) {
        if (ctxData == null) {
            return null;
        }
        Map props = (Map)ctxData.get("LOCAL_PROVIDER_CONFIG");
        if (props == null) {
            return null;
        }
        return (Configurable)props.get(providerName);
    }

    public void resetCredentials() {
        org.idoox.security.client.Current current = org.idoox.security.client.Current.getInstance();
        current.resetCredentials();
    }

    public String[] getAnRequirementsForEndpoint(String serverURL, String serviceEndpointPath) throws WebServiceLookupException {
        return this.getAnRequirementsForEndpoint(serverURL, serviceEndpointPath, false);
    }

    public String[] getAnRequirementsForEndpoint(String serverURL, String serviceEndpointPath, boolean isGetTransportMethod) throws WebServiceLookupException {
        if (serverURL != null) {
            SecurityInfoService service;
            Context.getInstance((String)"org.idoox.webservice.client.WebServiceLookup");
            try {
                service = (SecurityInfoService)SysServices.lookup((String)serverURL, (String)"Security Info", (String)"4.6");
            }
            catch (LookupException e) {
                throw new WebServiceLookupException("Unable to lookup security info service.", (Throwable)e);
            }
            try {
                SysServices.setInitiatingProvider((Object)service, null);
            }
            catch (NoSuchProviderException e) {
                // empty catch block
            }
            ServiceEndpoint se = new ServiceEndpoint(serviceEndpointPath, null);
            se.transportMethod = isGetTransportMethod ? 4 : 2;
            return service.getAcceptingSPForEndpoint(se);
        }
        Object anSupported = this.getInstalledSecurityInfo().get("AUTHENTICATION_SUPPORTED");
        if (anSupported != null && anSupported.equals("true")) {
            if (serviceEndpointPath == null) {
                return this.getDefaultAcceptingSecurityProviders();
            }
            Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
            Configurable configurable = isGetTransportMethod ? Configurator.getConfigurable((String)"GetServiceBinding", (String)serviceEndpointPath) : Configurator.getConfigurable((String)"ServiceBinding", (String)serviceEndpointPath);
            if (configurable == null) {
                return this.getDefaultAcceptingSecurityProviders();
            }
            ServiceBindingConfig serviceBindingConfig = (ServiceBindingConfig)configurable.narrow(class$com$idoox$wasp$server$config$ServiceBindingConfig == null ? (class$com$idoox$wasp$server$config$ServiceBindingConfig = WaspSecurityImpl.class$("com.idoox.wasp.server.config.ServiceBindingConfig")) : class$com$idoox$wasp$server$config$ServiceBindingConfig);
            if (serviceBindingConfig == null) {
                return this.getDefaultAcceptingSecurityProviders();
            }
            String[] toRet = serviceBindingConfig.getAcceptingSecurityProviders();
            if (toRet == null || toRet.length == 0) {
                return this.getDefaultAcceptingSecurityProviders();
            }
            if (toRet.length == 1 && toRet[0].equals("no")) {
                toRet = WaspSecurity.SPI.STRAR_0;
            }
            return toRet;
        }
        return WaspSecurity.SPI.STRAR_0;
    }

    private String[] getDefaultAcceptingSecurityProviders() {
        Object anSupported = this.getInstalledSecurityInfo().get("AUTHENTICATION_SUPPORTED");
        if (anSupported != null && anSupported.equals("true")) {
            Configurator configurator = (Configurator)Context.getInstance((String)"org.idoox.config.Configurator");
            Configurable conf = Configurator.getConfigurable((String)"securityPreferences", (String)"main");
            if (conf == null) {
                return WaspSecurity.SPI.STRAR_0;
            }
            SecurityModuleConfig secConf = (SecurityModuleConfig)conf.narrow(class$com$idoox$wasp$config$SecurityModuleConfig == null ? (class$com$idoox$wasp$config$SecurityModuleConfig = WaspSecurityImpl.class$("com.idoox.wasp.config.SecurityModuleConfig")) : class$com$idoox$wasp$config$SecurityModuleConfig);
            String[] result = secConf.getAcceptingSecurityProviders();
            if (result == null) {
                return WaspSecurity.SPI.STRAR_0;
            }
            return result;
        }
        return WaspSecurity.SPI.STRAR_0;
    }

    public void checkPermission(Permission perm) throws AccessControlException {
        try {
            WASPAccessController.checkPermission((Permission)perm);
            EventManager.fireEvent((Event)new LogEventAZSuccess(WaspSecurityImpl.getFirstPrincipalName(), perm.toString()));
        }
        catch (AccessControlException e) {
            EventManager.fireEvent((Event)new LogEventAZFailed(WaspSecurityImpl.getFirstPrincipalName(), e.getMessage()));
            throw e;
        }
    }

    private static String getFirstPrincipalName() {
        Set<Principal> set;
        Principal principal;
        org.idoox.security.server.Current cur = org.idoox.security.server.Current.getInstance();
        Subject subj = null;
        String principalName = null;
        ReceivedCredentials creds = cur.getReceivedCredentials();
        if (creds != null && (principal = (set = (subj = creds.getSubject()).getPrincipals()).iterator().next()) != null) {
            principalName = principal.getName();
        }
        return principalName;
    }

    protected Class getProviderPropertiesIface(String providerName) throws NoSuchProviderException {
        return org.idoox.security.client.Current.getInstance().getProvider(providerName).getPropertiesIface();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

