/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.helper;

import com.systinet.wasp.security.secext.algorithms.encryption.helper.InvalidCipherTextException;
import com.systinet.wasp.security.secext.utils.Base64;
import com.systinet.wasp.security.secext.utils.HexDump;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.RSAPrivateKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;

public class OAEPCipher {
    Cipher _cipher;
    int _cipherMode;
    MessageDigest _digest;
    int _hLen;
    byte[] _encodingParams;
    byte[] _encodingParamsHash;
    SecureRandom _secureRandom;

    public OAEPCipher(Cipher cipher, MessageDigest digest, byte[] encodingParams) {
        this._cipher = cipher;
        this._digest = digest;
        this._hLen = this._digest.getDigestLength();
        this._encodingParams = encodingParams != null ? encodingParams : new byte[0];
        this._digest.reset();
        this._digest.update(this._encodingParams);
        this._encodingParamsHash = this._digest.digest();
        this._digest.reset();
    }

    public void init(int mode, Key key, SecureRandom secureRandom) throws InvalidKeyException {
        this._cipherMode = mode;
        this._secureRandom = secureRandom;
        this._cipher.init(this._cipherMode, key, this._secureRandom);
    }

    public int getInputBlockSize() {
        int baseBlockSize = this._cipher.getBlockSize();
        int hLen = this._digest.getDigestLength();
        if (this._cipherMode == 1) {
            return baseBlockSize - 1 - 2 * hLen;
        }
        return baseBlockSize;
    }

    public int getOutputBlockSize() {
        int baseBlockSize = this._cipher.getBlockSize();
        int hLen = this._digest.getDigestLength();
        if (this._cipherMode == 1) {
            return baseBlockSize;
        }
        return baseBlockSize - 1 - 2 * hLen;
    }

    public byte[] processBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        if (this._cipherMode == 1) {
            return this.encodeBlock(in, inOff, inLen);
        }
        if (this._cipherMode == 2) {
            return this.decodeBlock(in, inOff, inLen);
        }
        return null;
    }

    public byte[] encodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        byte[] block = new byte[this.getInputBlockSize() + 1 + 2 * this._hLen];
        System.arraycopy(in, inOff, block, block.length - inLen, inLen);
        block[block.length - inLen - 1] = 1;
        System.arraycopy(this._encodingParamsHash, 0, block, this._hLen, this._hLen);
        byte[] seed = new byte[this._hLen];
        this._secureRandom.nextBytes(seed);
        byte[] mask = OAEPCipher.maskGeneratorFunction1(seed, 0, seed.length, block.length - this._hLen, this._digest);
        int i = this._hLen;
        while (i != block.length) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i - this._hLen]);
            ++i;
        }
        System.arraycopy(seed, 0, block, 0, this._hLen);
        mask = OAEPCipher.maskGeneratorFunction1(block, this._hLen, block.length - this._hLen, this._hLen, this._digest);
        int i2 = 0;
        while (i2 != this._hLen) {
            int n = i2;
            block[n] = (byte)(block[n] ^ mask[i2]);
            ++i2;
        }
        return this._cipher.doFinal(block, 0, block.length);
    }

    public byte[] decodeBlock(byte[] in, int inOff, int inLen) throws InvalidCipherTextException, IllegalBlockSizeException, BadPaddingException {
        byte[] data = this._cipher.doFinal(in, inOff, inLen);
        byte[] block = null;
        if (data.length < this.getOutputBlockSize()) {
            block = new byte[this.getOutputBlockSize()];
            System.arraycopy(data, 0, block, block.length - data.length, data.length);
        } else {
            block = data;
        }
        if (block.length < 2 * this._hLen + 1) {
            throw new InvalidCipherTextException("encryption.RSAOAEP.dataTooShort");
        }
        byte[] mask = OAEPCipher.maskGeneratorFunction1(block, this._hLen, block.length - this._hLen, this._hLen, this._digest);
        int i = 0;
        while (i != this._hLen) {
            int n = i;
            block[n] = (byte)(block[n] ^ mask[i]);
            ++i;
        }
        mask = OAEPCipher.maskGeneratorFunction1(block, 0, this._hLen, block.length - this._hLen, this._digest);
        int i2 = this._hLen;
        while (i2 != block.length) {
            int n = i2;
            block[n] = (byte)(block[n] ^ mask[i2 - this._hLen]);
            ++i2;
        }
        int i3 = 0;
        while (i3 != this._encodingParamsHash.length) {
            if (this._encodingParamsHash[i3] != block[this._encodingParamsHash.length + i3]) {
                throw new InvalidCipherTextException("encryption.RSAOAEP.dataHashWrong");
            }
            ++i3;
        }
        int start = 2 * this._hLen;
        while (start != block.length) {
            if (block[start] == 1 || block[start] != 0) break;
            ++start;
        }
        if (start >= block.length - 1 || block[start] != 1) {
            Object[] exArgs = new Object[]{new Integer(start)};
            throw new InvalidCipherTextException("encryption.RSAOAEP.dataStartWrong", exArgs);
        }
        byte[] output = new byte[block.length - ++start];
        System.arraycopy(block, start, output, 0, output.length);
        return output;
    }

    static void ItoOSP(int i, byte[] sp) {
        sp[0] = (byte)(i >>> 24);
        sp[1] = (byte)(i >>> 16);
        sp[2] = (byte)(i >>> 8);
        sp[3] = (byte)(i >>> 0);
    }

    static byte[] maskGeneratorFunction1(byte[] Z, int zOff, int zLen, int length, MessageDigest Hash) throws IllegalArgumentException {
        byte[] hashBuf;
        int hLen = Hash.getDigestLength();
        byte[] mask = new byte[length];
        byte[] C = new byte[4];
        int counter = 0;
        Hash.reset();
        do {
            OAEPCipher.ItoOSP(counter, C);
            Hash.update(Z, zOff, zLen);
            Hash.update(C, 0, C.length);
            hashBuf = Hash.digest();
            System.arraycopy(hashBuf, 0, mask, counter * hLen, hLen);
        } while (++counter < length / hLen);
        if (counter * hLen < length) {
            OAEPCipher.ItoOSP(counter, C);
            Hash.update(Z, zOff, zLen);
            Hash.update(C, 0, C.length);
            hashBuf = Hash.digest();
            System.arraycopy(hashBuf, 0, mask, counter * hLen, mask.length - counter * hLen);
        }
        return mask;
    }

    public static void main(String[] args) throws Exception {
        Cipher rsaCipher = Cipher.getInstance("RSA", "BC");
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1", "BC");
        byte[] encodingParams = Base64.decode("9lWu3Q==");
        OAEPCipher OAEPCipher1 = new OAEPCipher(rsaCipher, sha1, null);
        BigInteger modulus = new BigInteger("bbf82f090682ce9c2338ac2b9da871f7368d07eed41043a440d6b6f07454f51fb8dfbaaf035c02ab61ea48ceeb6fcd4876ed520d60e1ec4619719d8a5b8b807fafb8e0a3dfc737723ee6b4b7d93a2584ee6a649d060953748834b2454598394ee0aab12d7b61a51f527a9a41f6c1687fe2537298ca2a8f5946f8e5fd091dbdcb", 16);
        BigInteger privateExponent = new BigInteger("a5dafc5341faf289c4b988db30c1cdf83f31251e0668b42784813801579641b29410b3c7998d6bc465745e5c392669d6870da2c082a939e37fdcb82ec93edac97ff3ad5950accfbc111c76f1a9529444e56aaf68c56c092cd38dc3bef5d20a939926ed4f74a13eddfbe1a1cecc4894af9428c2b7b8883fe4463a4bc85b1cb3c1", 16);
        String cipherText = "12 53 e0 4d c0 a5 39 7b b4 4a 7a b8 7e 9b f2 a0 39 a3 3d 1e 99 6f c8 2a 94 cc d3 00 74 c9 5d f7 63 72 20 17 06 9e 52 68 da 5d 1c 0b 4f 87 2c f6 53 c1 1d f8 23 14 a6 79 68 df ea e2 8d ef 04 bb 6d 84 b1 c3 1d 65 4a 19 70 e5 78 3b d6 eb 96 a0 24 c2 ca 2f 4a 90 fe 9f 2e f5 c9 c1 40 e5 bb 48 da 95 36 ad 87 00 c8 4f c9 13 0a de a7 4e 55 8d 51 a7 4d df 85 d8 b5 0d e9 68 38 d6 06 3e 09 55 ";
        KeyFactory kf = KeyFactory.getInstance("RSA", "BC");
        RSAPrivateKeySpec rsaKeySpec = new RSAPrivateKeySpec(modulus, privateExponent);
        PrivateKey pK = kf.generatePrivate(rsaKeySpec);
        OAEPCipher1.init(2, pK, new SecureRandom());
        byte[] oaepBytes = HexDump.hexStringToByteArray(cipherText);
        byte[] oaepPlainBytes = OAEPCipher1.processBlock(oaepBytes, 0, oaepBytes.length);
        System.out.println(HexDump.byteArrayToHexString(oaepPlainBytes));
    }
}

