/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.implementations.BC;

import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.algorithms.MessageDigestAlgorithm;
import com.systinet.wasp.security.secext.algorithms.encryption.helper.OAEPCipher;
import com.systinet.wasp.security.secext.algorithms.encryption.implementations.BC.KeyTransportImpl;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.algorithms.encryption.params.OAEPParams;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import com.systinet.wasp.security.secext.utils.PRNG;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyTransportImpl_RSAOAEP_BC
extends KeyTransportImpl {
    OAEPParams _params = null;
    OAEPCipher _cipher = null;

    public int engineGetIvLength() {
        return -1;
    }

    public String getImplementedAlgorithmURI() {
        return "http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p";
    }

    public int engineGetBlockSize() {
        if (this._cipher != null) {
            return this._cipher.getInputBlockSize();
        }
        return 0;
    }

    public EncryptionMethodParams engineInit(Document doc, EncryptionMethodParams params) throws XMLSecurityException {
        this._doc = doc;
        if (params == null) {
            this._params = new OAEPParams(null, null);
        } else if (params instanceof OAEPParams) {
            this._params = (OAEPParams)params;
        } else {
            throw new XMLSecurityException("empty", new Object[]{"Paramter of RSAOAEP is not instance-of OAEPParams"});
        }
        try {
            Cipher rsaCipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            MessageDigestAlgorithm mda = MessageDigestAlgorithm.getInstance(this._doc, this._params.getDigestMethodURI());
            MessageDigest md = mda.getAlgorithm();
            this._cipher = new OAEPCipher(rsaCipher, md, this._params.getOAEPParamBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        return this._params;
    }

    public EncryptionMethodParams engineInit(Element encryptionMethodElem) throws XMLSecurityException {
        this._params = new OAEPParams(encryptionMethodElem);
        try {
            Cipher rsaCipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
            MessageDigestAlgorithm mda = MessageDigestAlgorithm.getInstance(this._doc, this._params.getDigestMethodURI());
            MessageDigest md = mda.getAlgorithm();
            this._cipher = new OAEPCipher(rsaCipher, md, this._params.getOAEPParamBytes());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        return this._params;
    }

    public byte[] engineWrap(Key contentKey, Key wrapKey) throws XMLSecurityException {
        try {
            this._cipher.init(1, wrapKey, PRNG.getInstance().getSecureRandom());
            byte[] contentKeyBytes = contentKey.getEncoded();
            return this._cipher.encodeBlock(contentKeyBytes, 0, contentKeyBytes.length);
        }
        catch (BadPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public Key engineUnwrap(byte[] wrappedKey, Key wrapKey, String wrappedKeyAlgoURI) throws XMLSecurityException {
        try {
            this._cipher.init(2, wrapKey, null);
            String keyAlgorithm = JCEMapper.translateURItoJCEID(wrappedKeyAlgoURI, this.getRequiredProviderName()).getAlgorithmID();
            int keyType = JCEMapper.getKeyTypeFromURI(wrappedKeyAlgoURI);
            byte[] decoded = this._cipher.decodeBlock(wrappedKey, 0, wrappedKey.length);
            if (keyType == 3) {
                return new SecretKeySpec(decoded, keyAlgorithm);
            }
            try {
                KeyFactory kf = KeyFactory.getInstance(keyAlgorithm, this.getRequiredProviderName());
                if (keyType == 1) {
                    return kf.generatePublic(new X509EncodedKeySpec(decoded));
                }
                if (keyType == 2) {
                    return kf.generatePrivate(new PKCS8EncodedKeySpec(decoded));
                }
            }
            catch (NoSuchProviderException e) {
                throw new InvalidKeyException("Unknown key type " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException("Unknown key type " + e.getMessage());
            }
            catch (InvalidKeySpecException e2) {
                throw new InvalidKeyException("Unknown key type " + e2.getMessage());
            }
            throw new InvalidKeyException("Unknown key type " + keyType);
        }
        catch (BadPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (IllegalBlockSizeException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }
}

