/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.algorithms.encryption.implementations.BC;

import com.systinet.wasp.security.secext.algorithms.JCEMapper;
import com.systinet.wasp.security.secext.algorithms.encryption.EncryptionMethodSpi;
import com.systinet.wasp.security.secext.algorithms.encryption.helper.AESWrapper;
import com.systinet.wasp.security.secext.algorithms.encryption.params.EncryptionMethodParams;
import com.systinet.wasp.security.secext.exceptions.XMLSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class KeyWrapImpl_AES_BC
extends EncryptionMethodSpi {
    Cipher _cipher;

    public abstract String getRequiredProviderName();

    public abstract String getImplementedAlgorithmURI();

    public int getImplementedAlgorithmType() {
        return 4;
    }

    public int engineGetBlockSize() {
        return this._cipher.getBlockSize();
    }

    public abstract int engineGetIvLength();

    public EncryptionMethodParams engineInit(Document doc, EncryptionMethodParams params) throws XMLSecurityException {
        if (params != null) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        return params;
    }

    public EncryptionMethodParams engineInit(Element encryptionMethodElem) throws XMLSecurityException {
        if (encryptionMethodElem.getChildNodes().getLength() != 0) {
            throw new XMLSecurityException("encryption.algorithmCannotEatInitParams");
        }
        try {
            this._cipher = Cipher.getInstance(this.getImplementedAlgorithmJCE(), this.getRequiredProviderName());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchProviderException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        catch (NoSuchPaddingException ex) {
            throw new XMLSecurityException("empty", ex);
        }
        return null;
    }

    public byte[] engineWrap(Key contentKey, Key wrapKey) throws XMLSecurityException {
        return this.engineWrap(contentKey, wrapKey, null);
    }

    public byte[] engineWrap(Key contentKey, Key wrapKey, byte[] IV) throws XMLSecurityException {
        if (IV != null && IV.length != 8) {
            throw new XMLSecurityException("empty", new Object[]{"AES's IV has wrong size"});
        }
        AESWrapper aw = new AESWrapper(this._cipher);
        return aw.wrap(contentKey, wrapKey, IV);
    }

    public Key engineUnwrap(byte[] wrappedKey, Key wrapKey, String wrappedKeyURI) throws XMLSecurityException {
        try {
            String wrappedKeyAlgorithm = JCEMapper.translateURItoJCEID(wrappedKeyURI, this.getRequiredProviderName()).getAlgorithmID();
            int wrappedKeyType = JCEMapper.getKeyTypeFromURI(wrappedKeyURI);
            AESWrapper wrapper = new AESWrapper(this._cipher);
            byte[] encoded = wrapper.unwrap(wrappedKey, wrapKey);
            if (wrappedKeyType == 3) {
                return new SecretKeySpec(encoded, wrappedKeyAlgorithm);
            }
            try {
                KeyFactory kf = KeyFactory.getInstance(wrappedKeyAlgorithm, this.getRequiredProviderName());
                if (wrappedKeyType == 1) {
                    return kf.generatePublic(new X509EncodedKeySpec(encoded));
                }
                if (wrappedKeyType == 2) {
                    return kf.generatePrivate(new PKCS8EncodedKeySpec(encoded));
                }
            }
            catch (NoSuchProviderException e) {
                throw new InvalidKeyException("Unknown key type " + e.getMessage());
            }
            catch (NoSuchAlgorithmException e) {
                throw new InvalidKeyException("Unknown key type " + e.getMessage());
            }
            catch (InvalidKeySpecException e2) {
                throw new InvalidKeyException("Unknown key type " + e2.getMessage());
            }
            throw new InvalidKeyException("Unknown key type " + wrappedKeyType);
        }
        catch (InvalidKeyException ex) {
            throw new XMLSecurityException("empty", ex);
        }
    }

    public byte[] engineEncrypt(byte[] plaintextBytes, Key contentKey) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }

    public byte[] engineEncrypt(byte[] plaintextBytes, Key contentKey, byte[] IV) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }

    public byte[] engineDecrypt(byte[] ciphertextBytes, Key contentKey) throws XMLSecurityException {
        throw new XMLSecurityException("encryption.algorithmCannotEncryptDecrypt");
    }
}

