/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.wasp.security.secext.c14n.helper;

import com.systinet.wasp.security.secext.c14n.CanonicalizationException;
import com.systinet.wasp.security.secext.c14n.helper.AttrCompare;
import java.util.Arrays;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;

public class C14nHelper {
    private C14nHelper() {
    }

    public static final Object[] sortAttributes(Object[] attributes) {
        if (attributes == null) {
            return new Attr[0];
        }
        Object[] result = new Object[attributes.length];
        int i = 0;
        while (i < attributes.length) {
            result[i] = attributes[i];
            ++i;
        }
        Arrays.sort(result, new AttrCompare());
        return result;
    }

    public static final String normalizeAttr(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = s == null ? 0 : s.length();
        int j = 0;
        while (j < i) {
            char c = s.charAt(j);
            switch (c) {
                case '&': {
                    stringbuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringbuffer.append("&lt;");
                    break;
                }
                case '\"': {
                    stringbuffer.append("&quot;");
                    break;
                }
                case '\t': {
                    stringbuffer.append("&#x9;");
                    break;
                }
                case '\n': {
                    stringbuffer.append("&#xA;");
                    break;
                }
                case '\r': {
                    stringbuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringbuffer.append(c);
                }
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    public static final String normalizeComment(String s) {
        return C14nHelper.normalizeProcessingInstruction(s);
    }

    public static final String normalizeProcessingInstruction(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = s == null ? 0 : s.length();
        int j = 0;
        while (j < i) {
            char c = s.charAt(j);
            switch (c) {
                case '\r': {
                    stringbuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringbuffer.append(c);
                }
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    public static final String normalizeText(String s) {
        StringBuffer stringbuffer = new StringBuffer();
        int i = s == null ? 0 : s.length();
        int j = 0;
        while (j < i) {
            char c = s.charAt(j);
            switch (c) {
                case '&': {
                    stringbuffer.append("&amp;");
                    break;
                }
                case '<': {
                    stringbuffer.append("&lt;");
                    break;
                }
                case '>': {
                    stringbuffer.append("&gt;");
                    break;
                }
                case '\r': {
                    stringbuffer.append("&#xD;");
                    break;
                }
                default: {
                    stringbuffer.append(c);
                }
            }
            ++j;
        }
        return stringbuffer.toString();
    }

    public static boolean namespaceIsRelative(Attr namespace) {
        return !C14nHelper.namespaceIsAbsolute(namespace);
    }

    public static boolean namespaceIsRelative(String namespaceValue) {
        return !C14nHelper.namespaceIsAbsolute(namespaceValue);
    }

    public static boolean namespaceIsAbsolute(Attr namespace) {
        return C14nHelper.namespaceIsAbsolute(namespace.getValue());
    }

    public static boolean namespaceIsAbsolute(String namespaceValue) {
        if (namespaceValue.length() == 0) {
            return true;
        }
        boolean foundColon = false;
        int length = namespaceValue.length();
        int i = 0;
        while (i < length) {
            char c = namespaceValue.charAt(i);
            if (c == ':') {
                foundColon = true;
            } else if (!foundColon && c == '/') {
                return false;
            }
            ++i;
        }
        return foundColon;
    }

    public static void assertNotRelativeNS(Attr attr) throws CanonicalizationException {
        if (attr == null) {
            return;
        }
        String nodeAttrName = attr.getNodeName();
        boolean definesDefaultNS = nodeAttrName.equals("xmlns");
        boolean definesNonDefaultNS = nodeAttrName.startsWith("xmlns:");
        if ((definesDefaultNS || definesNonDefaultNS) && C14nHelper.namespaceIsRelative(attr)) {
            String parentName = attr.getOwnerElement().getTagName();
            String attrValue = attr.getValue();
            Object[] exArgs = new Object[]{parentName, nodeAttrName, attrValue};
            throw new CanonicalizationException("c14n.Canonicalizer.RelativeNamespace", exArgs);
        }
    }

    public static void checkTraversability(Document document) throws CanonicalizationException {
        if (!document.isSupported("Traversal", "2.0")) {
            Object[] exArgs = new Object[]{document.getImplementation().getClass().getName()};
            throw new CanonicalizationException("c14n.Canonicalizer.TraversalNotSupported", exArgs);
        }
    }

    public static void checkForRelativeNamespace(Element ctxNode) throws CanonicalizationException {
        if (ctxNode != null) {
            NamedNodeMap attributes = ctxNode.getAttributes();
            int i = 0;
            while (i < attributes.getLength()) {
                C14nHelper.assertNotRelativeNS((Attr)attributes.item(i));
                ++i;
            }
        } else {
            throw new CanonicalizationException("Called checkForRelativeNamespace() on null");
        }
    }
}

